/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mail;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.HashMap;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MailTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final String GREENMAIL_IMAGE_NAME = "greenmail/standalone:1.6.7";
    private GenericContainer<?> container;

    public Map<String, String> start() {
        this.container = new GenericContainer(DockerImageName.parse((String)GREENMAIL_IMAGE_NAME)).withExposedPorts(MailProtocol.allPorts()).waitingFor((WaitStrategy)new HttpWaitStrategy().forPort(MailProtocol.API.getPort()).forPath("/api/service/readiness").forStatusCode(200));
        this.container.start();
        HashMap<String, String> options = new HashMap<String, String>();
        for (MailProtocol protocol : MailProtocol.values()) {
            String optionName = String.format("mail.%s.port", protocol.name().toLowerCase());
            Integer mappedPort = this.container.getMappedPort(protocol.getPort());
            options.put(optionName, mappedPort.toString());
        }
        return options;
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    static enum MailProtocol {
        SMTP(3025),
        POP3(3110),
        IMAP(3143),
        SMTPS(3465),
        IMAPS(3993),
        POP3s(3995),
        API(8080);

        private final int port;

        private MailProtocol(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public static Integer[] allPorts() {
            MailProtocol[] values = MailProtocol.values();
            Integer[] ports = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ports[i] = values[i].getPort();
            }
            return ports;
        }
    }
}

