/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mail;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ServiceStatus;
import org.apache.camel.quarkus.component.mail.CamelRoute;
import org.apache.camel.quarkus.component.mail.MailTestResource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.testcontainers.shaded.org.awaitility.Awaitility;

@QuarkusTest
@QuarkusTestResource(value=MailTestResource.class)
public class MailTest {
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("\r\n[^\r\n]+");
    private static final String EXPECTED_TEMPLATE = "${delimiter}\r\nContent-Type: text/plain; charset=UTF8; other-parameter=true\r\nContent-Transfer-Encoding: 8bit\r\n\r\nHello multipart!${delimiter}\r\nContent-Type: text/plain\r\nContent-Transfer-Encoding: 8bit\r\nContent-Disposition: attachment; filename=file.txt\r\nContent-Description: Sample Attachment Data\r\nX-AdditionalData: additional data\r\n\r\nHello attachment!${delimiter}--\r\n";

    @BeforeEach
    public void beforeEach() {
        Config config = ConfigProvider.getConfig();
        String userJson = String.format("{ \"email\": \"%s\", \"login\": \"%s\", \"password\": \"%s\"}", "test@localhost", "test", "s3cr3t");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(userJson).post("http://localhost:" + config.getValue("mail.api.port", Integer.class) + "/api/user", new Object[0])).then()).statusCode(200);
    }

    @AfterEach
    public void afterEach() {
        Config config = ConfigProvider.getConfig();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(((Integer)config.getValue("mail.api.port", Integer.class)).intValue()).post("/api/service/reset", new Object[0])).then()).statusCode(200)).body("message", Matchers.is((Object)"Performed reset"), new Object[0]);
        ((ValidatableResponse)RestAssured.get((String)"/mail/stopConsumers", (Object[])new Object[0]).then()).statusCode(204);
        ((ValidatableResponse)RestAssured.get((String)"/mail/clear", (Object[])new Object[0]).then()).statusCode(204);
    }

    @ParameterizedTest
    @ValueSource(strings={"pop3", "imap"})
    public void receive(String protocol) {
        this.startRoute("pop3".equals(protocol) ? CamelRoute.Routes.pop3ReceiveRoute : CamelRoute.Routes.imapReceiveRoute);
        this.send(false);
    }

    @ParameterizedTest
    @ValueSource(strings={"pop3s", "imaps"})
    public void receiveSecured(String protocol) {
        this.startRoute("pop3s".equals(protocol) ? CamelRoute.Routes.pop3sReceiveRoute : CamelRoute.Routes.imapsReceiveRoute);
        this.send(true);
    }

    private void send(boolean secured) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("subject", new Object[]{"Hello World"}).queryParam("from", new Object[]{"camel@localhost"}).queryParam("to", new Object[]{"test@localhost"}).queryParam("secured", new Object[]{secured}).body("Hi how are you").post("/mail/send", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> (List)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mail/getReceived/", (Object[])new Object[0]).then()).statusCode(200)).extract().as(List.class), list -> list.size() == 1 && "Hi how are you".equals(((Map)list.get(0)).get("content")) && "Hello World".equals(((Map)list.get(0)).get("subject")));
    }

    @Test
    public void mimeMultipartDataFormat() {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Hello multipart!").post("/mail/mimeMultipartMarshal/file.txt/Hello attachment!", new Object[0])).then()).statusCode(200)).extract().body().asString();
        this.assertMultipart(EXPECTED_TEMPLATE, actual);
        String unmarshalMarshal = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(actual).post("/mail/mimeMultipartUnmarshalMarshal", new Object[0])).then()).statusCode(200)).extract().body().asString();
        this.assertMultipart(EXPECTED_TEMPLATE, unmarshalMarshal);
    }

    private void assertMultipart(String expectedPattern, String actual) {
        Matcher m = DELIMITER_PATTERN.matcher(actual);
        if (!m.find()) {
            Assertions.fail((String)("Mime delimiter not found in body: " + actual));
        }
        String delim = m.group();
        String expected = expectedPattern.replace("${delimiter}", delim);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttachments() throws IOException, URISyntaxException {
        this.startRoute(CamelRoute.Routes.pop3ReceiveRoute);
        String mailBodyContent = "Test mail content";
        String attachmentContent = "Attachment " + mailBodyContent;
        Path attachmentPath = Files.createTempFile("cq-attachment", ".txt", new FileAttribute[0]);
        Files.write(attachmentPath, attachmentContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("subject", new Object[]{"Test attachment message"}).queryParam("from", new Object[]{"camel@localhost"}).queryParam("to", new Object[]{"test@localhost"}).body(mailBodyContent).post("/mail/send/attachment/{fileName}", new Object[]{attachmentPath.toAbsolutePath().toString()})).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("subject", new Object[]{"Test attachment message"}).queryParam("from", new Object[]{"camel@localhost"}).queryParam("to", new Object[]{"test@localhost"}).body(mailBodyContent).post("/mail/send/attachment/{fileName}", new Object[]{"logo.jpeg"})).then()).statusCode(204);
            Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> (List)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mail/getReceived/", (Object[])new Object[0]).then()).statusCode(200)).extract().as(List.class), list -> {
                if (list.size() == 2) {
                    Map msg1 = (Map)list.get(0);
                    List attch1 = (List)msg1.get("attachments");
                    Map msg2 = (Map)list.get(1);
                    List attch2 = (List)msg2.get("attachments");
                    return !(!"Test mail content".equals(msg1.get("content")) || !"Test attachment message".equals(msg1.get("subject")) || !attachmentPath.getFileName().toString().equals(((Map)attch1.get(0)).get("attachmentFilename")) || !attachmentContent.equals(((Map)attch1.get(0)).get("attachmentContent")) || !((Map)attch1.get(0)).get("attachmentContentType").toString().startsWith("text/plain") && !((Map)attch1.get(0)).get("attachmentContentType").toString().startsWith("application/octet-stream") || !"Test mail content".equals(msg2.get("content")) || !"Test attachment message".equals(msg2.get("subject")) || !"logo.jpeg".equals(((Map)attch2.get(0)).get("attachmentFilename")) || !((Map)attch2.get(0)).get("attachmentContentType").toString().startsWith("image/jpeg") && !((Map)attch2.get(0)).get("attachmentContentType").toString().toString().startsWith("application/octet-stream"));
                }
                return false;
            });
        }
        finally {
            Files.deleteIfExists(attachmentPath);
        }
    }

    @Test
    public void testBatchConsumer() {
        this.startRoute(CamelRoute.Routes.batchReceiveRoute);
        IntStream.range(1, 5).boxed().forEach(i -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).contentType(ContentType.TEXT).queryParam("subject", new Object[]{"Test batch consumer"}).queryParam("from", new Object[]{"camel@localhost"}).queryParam("to", new Object[]{"test@localhost"}).body("message " + i).post("/mail/send", new Object[0])).then()).statusCode(204));
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> (List)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mail/getReceived/", (Object[])new Object[0]).then()).statusCode(200)).extract().as(List.class), list -> list.size() == 4 && "message 1".equals(((Map)list.get(0)).get("content")) && "Test batch consumer".equals(((Map)list.get(0)).get("subject")) && "0".equals(((Map)list.get(0)).get(ExchangePropertyKey.BATCH_INDEX.getName()).toString()) && "3".equals(((Map)list.get(0)).get(ExchangePropertyKey.BATCH_SIZE.getName()).toString()) && (Boolean)((Map)list.get(0)).get(ExchangePropertyKey.BATCH_COMPLETE.getName()) == false && "message 2".equals(((Map)list.get(1)).get("content")) && "Test batch consumer".equals(((Map)list.get(1)).get("subject")) && "1".equals(((Map)list.get(1)).get(ExchangePropertyKey.BATCH_INDEX.getName()).toString()) && (Boolean)((Map)list.get(1)).get(ExchangePropertyKey.BATCH_COMPLETE.getName()) == false && "message 3".equals(((Map)list.get(2)).get("content")) && "Test batch consumer".equals(((Map)list.get(2)).get("subject")) && "2".equals(((Map)list.get(2)).get(ExchangePropertyKey.BATCH_INDEX.getName()).toString()) && (Boolean)((Map)list.get(2)).get(ExchangePropertyKey.BATCH_COMPLETE.getName()) != false && "message 4".equals(((Map)list.get(3)).get("content")) && "Test batch consumer".equals(((Map)list.get(3)).get("subject")) && "0".equals(((Map)list.get(3)).get(ExchangePropertyKey.BATCH_INDEX.getName()).toString()));
    }

    @Test
    public void testConverters() throws Exception {
        this.startRoute(CamelRoute.Routes.convertersRoute);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).contentType(ContentType.TEXT).queryParam("subject", new Object[]{"Camel Rocks"}).queryParam("from", new Object[]{"camel@localhost"}).queryParam("to", new Object[]{"test@localhost"}).body("Hello World ").post("/mail/send", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> (List)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mail/getReceivedAsString/", (Object[])new Object[0]).then()).statusCode(200)).extract().as(List.class), list -> list.size() == 1 && ((String)((Map)list.get(0)).get("body")).matches("Hello World\\s*"));
    }

    @Test
    public void testSort() {
        List msgs = IntStream.range(1, 5).boxed().map(i -> "message " + i).collect(Collectors.toList());
        Collections.reverse(msgs);
        List sorted = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(msgs).post("/mail/sort", new Object[0])).then()).statusCode(200)).extract().as(List.class);
        Assertions.assertEquals((int)4, (int)sorted.size());
        Assertions.assertTrue((boolean)((String)sorted.get(0)).contains("message 1"));
        Assertions.assertTrue((boolean)((String)sorted.get(1)).contains("message 2"));
        Assertions.assertTrue((boolean)((String)sorted.get(2)).contains("message 3"));
        Assertions.assertTrue((boolean)((String)sorted.get(3)).contains("message 4"));
    }

    private void startRoute(CamelRoute.Routes route) {
        ((ValidatableResponse)((Response)RestAssured.given().get("/mail/route/" + route.name() + "/start", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
            String status = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/mail/route/" + route.name() + "/status"), (Object[])new Object[0]).then()).statusCode(200)).extract().asString();
            return status.equals(ServiceStatus.Started.name());
        });
    }
}

