/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mail;

import javax.activation.DataSource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;

@Path(value="/mail")
@ApplicationScoped
public class CamelResource {
    @Inject
    ProducerTemplate template;

    @Path(value="/route/{route}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String route(String statement, @PathParam(value="route") String route) throws Exception {
        return (String)this.template.requestBody("direct:" + route, (Object)statement, String.class);
    }

    @Path(value="/mimeMultipartMarshal/{fileName}/{fileContent}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String mimeMultipart(String body, @PathParam(value="fileName") String fileName, @PathParam(value="fileContent") String fileContent) throws Exception {
        return (String)this.template.request("direct:mimeMultipartMarshal", e -> {
            AttachmentMessage in = (AttachmentMessage)e.getMessage(AttachmentMessage.class);
            in.setBody((Object)body);
            in.setHeader("Content-Type", (Object)"text/plain;charset=iso8859-1;other-parameter=true");
            in.setHeader("Content-Encoding", (Object)"UTF8");
            DefaultAttachment attachment = new DefaultAttachment((DataSource)new ByteArrayDataSource(fileContent, "text/plain"));
            attachment.addHeader("Content-Description", "Sample Attachment Data");
            attachment.addHeader("X-AdditionalData", "additional data");
            in.addAttachmentObject(fileName, (Attachment)attachment);
        }).getMessage().getBody(String.class);
    }
}

