/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.lumberjack.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.camel.quarkus.component.lumberjack.it.LumberjackAckResponse;
import org.apache.camel.quarkus.component.lumberjack.it.LumberjackClientUtil;
import org.apache.camel.quarkus.component.lumberjack.it.LumberjackResource;
import org.apache.camel.quarkus.component.lumberjack.it.LumberjackTestResource;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestHTTPEndpoint(value=LumberjackResource.class)
@QuarkusTestResource(value=LumberjackTestResource.class)
class LumberjackTest {
    static final int VERSION_V2 = 50;
    static final int TYPE_ACKNOWLEDGE = 65;

    LumberjackTest() {
    }

    @Test
    public void testWithoutSSL() throws InterruptedException {
        List<LumberjackAckResponse> ackResponseList = this.sendPayload("camel.lumberjack.ssl.none.test-port", false);
        this.assertAck(ackResponseList);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/results/ssl/none", new Object[0])).then()).statusCode(200)).body("logs", Matchers.hasSize((int)25), new Object[0])).body("logs[0].input_type", Matchers.equalTo((Object)"log"), new Object[0])).body("logs[0].source", Matchers.equalTo((Object)"/home/qatest/collectNetwork/log/data-integration/00000000-f000-0000-1541-8da26f200001/absorption.log"), new Object[0]);
    }

    @Test
    public void testWitSSL() throws InterruptedException {
        List<LumberjackAckResponse> ackResponseList = this.sendPayload("camel.lumberjack.ssl.test-port", true);
        this.assertAck(ackResponseList);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/results/ssl/route", new Object[0])).then()).statusCode(200)).body("logs", Matchers.hasSize((int)25), new Object[0])).body("logs[0].input_type", Matchers.equalTo((Object)"log"), new Object[0])).body("logs[0].source", Matchers.equalTo((Object)"/home/qatest/collectNetwork/log/data-integration/00000000-f000-0000-1541-8da26f200001/absorption.log"), new Object[0]);
    }

    @Test
    public void testWitGlobalSSL() throws InterruptedException {
        List<LumberjackAckResponse> ackResponseList = this.sendPayload("camel.lumberjack.ssl.global.test-port", true);
        this.assertAck(ackResponseList);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/results/ssl/global", new Object[0])).then()).statusCode(200)).body("logs", Matchers.hasSize((int)25), new Object[0])).body("logs[0].input_type", Matchers.equalTo((Object)"log"), new Object[0])).body("logs[0].source", Matchers.equalTo((Object)"/home/qatest/collectNetwork/log/data-integration/00000000-f000-0000-1541-8da26f200001/absorption.log"), new Object[0]);
    }

    private void assertAck(List<LumberjackAckResponse> ackResponseList) {
        Assertions.assertEquals((int)2, (int)ackResponseList.size());
        Assertions.assertEquals((int)50, (int)ackResponseList.get(0).getVersion());
        Assertions.assertEquals((int)50, (int)ackResponseList.get(1).getVersion());
        Assertions.assertEquals((int)65, (int)ackResponseList.get(0).getFrame());
        Assertions.assertEquals((int)65, (int)ackResponseList.get(1).getFrame());
        Assertions.assertEquals((int)10, (int)ackResponseList.get(0).getSequence());
        Assertions.assertEquals((int)15, (int)ackResponseList.get(1).getSequence());
        Assertions.assertEquals((int)0, (int)ackResponseList.get(0).getRemaining());
        Assertions.assertEquals((int)0, (int)ackResponseList.get(1).getRemaining());
    }

    private List<LumberjackAckResponse> sendPayload(String portName, boolean withSsl) throws InterruptedException {
        int port = (Integer)ConfigProvider.getConfig().getValue(portName, Integer.class);
        List<LumberjackAckResponse> ackResponseList = LumberjackClientUtil.sendMessages(port, withSsl);
        return ackResponseList;
    }
}

