/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.lumberjack.it;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.camel.quarkus.component.lumberjack.it.LumberjackAckResponse;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;

public class LumberjackClientUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LumberjackAckResponse> sendMessages(int port, boolean withSslContextParameters) throws InterruptedException {
        final SSLContextParameters sslContextParameters = withSslContextParameters ? LumberjackClientUtil.createClientSSLContextParameters() : null;
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        try {
            final ArrayList<LumberjackAckResponse> responses = new ArrayList<LumberjackAckResponse>();
            ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (sslContextParameters != null) {
                        SSLEngine sslEngine = sslContextParameters.createSSLContext(null).createSSLEngine();
                        sslEngine.setUseClientMode(true);
                        pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                            short version = msg.readUnsignedByte();
                            short frame = msg.readUnsignedByte();
                            int sequence = msg.readInt();
                            int remaining = msg.readableBytes();
                            List list = responses;
                            synchronized (list) {
                                responses.add(new LumberjackAckResponse(version, frame, sequence, remaining));
                            }
                        }
                    }});
                }
            };
            Channel channel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)initializer)).connect("127.0.0.1", port).sync().channel();
            TimeUnit.MILLISECONDS.sleep(500L);
            channel.writeAndFlush((Object)LumberjackClientUtil.readSample("io/window10.bin"));
            TimeUnit.MILLISECONDS.sleep(500L);
            channel.writeAndFlush((Object)LumberjackClientUtil.readSample("io/window15.bin"));
            TimeUnit.MILLISECONDS.sleep(500L);
            channel.close();
            ArrayList<LumberjackAckResponse> arrayList = responses;
            synchronized (arrayList) {
                ArrayList<LumberjackAckResponse> arrayList2 = responses;
                return arrayList2;
            }
        }
        finally {
            eventLoopGroup.shutdownGracefully();
        }
    }

    private static ByteBuf readSample(String resource) {
        ByteBuf byteBuf;
        block9: {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            try {
                int input;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((input = stream.read()) != -1) {
                    output.write(input);
                }
                byteBuf = Unpooled.wrappedBuffer((byte[])output.toByteArray());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read sample data", e);
                }
            }
            stream.close();
        }
        return byteBuf;
    }

    public static SSLContextParameters createClientSSLContextParameters() {
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        TrustManagersParameters trustManagersParameters = new TrustManagersParameters();
        KeyStoreParameters trustStore = new KeyStoreParameters();
        trustStore.setPassword("changeit");
        trustStore.setResource("ssl/keystore.jks");
        trustManagersParameters.setKeyStore(trustStore);
        sslContextParameters.setTrustManagers(trustManagersParameters);
        return sslContextParameters;
    }
}

