/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.log.it;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class LogUtils {
    private LogUtils() {
    }

    public static boolean isNativeMode() {
        return "executable".equals(System.getProperty("org.graalvm.nativeimage.kind"));
    }

    public static Path resolveQuarkusLogPath() {
        Path quarkusLog;
        Path logDir = Paths.get(".", "target");
        Path path = quarkusLog = LogUtils.isNativeMode() ? logDir.resolve("target/quarkus.log") : logDir.resolve("quarkus.log");
        if (!Files.exists(quarkusLog, new LinkOption[0])) {
            try {
                Files.createDirectories(quarkusLog.getParent(), new FileAttribute[0]);
                Files.createFile(quarkusLog, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return quarkusLog;
    }
}

