/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.log.it;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.quarkus.component.log.it.LogUtils;
import org.apache.camel.quarkus.component.log.it.MdcLoggingTestProfile;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=MdcLoggingTestProfile.class)
public class MdcLogTest {
    private static final Pattern MDC_LOG_PATTERN = Pattern.compile("^MDC\\[\\{(.*)},(.*)]");

    @Test
    void mdcLogging() {
        Path quarkusLog = LogUtils.resolveQuarkusLogPath();
        String message = "Hello Camel Quarkus MDC Logging";
        String id = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:mdcLog"}).body(message).post("/log", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> {
            Map<String, String> mdc = this.parseMdcLogEntries(quarkusLog);
            if (mdc.isEmpty()) {
                return false;
            }
            Assertions.assertEquals((Object)id, (Object)mdc.get("camel.breadcrumbId"));
            Assertions.assertEquals((Object)"mdc-logging", (Object)mdc.get("camel.contextId"));
            Assertions.assertEquals((Object)id, (Object)mdc.get("camel.exchangeId"));
            Assertions.assertEquals((Object)id, (Object)mdc.get("camel.messageId"));
            Assertions.assertTrue((boolean)mdc.get("message").contains(message));
            Assertions.assertEquals((Object)"mdc-log", (Object)mdc.get("camel.routeId"));
            return true;
        });
    }

    @Test
    void mdcLoggingFromExceptionHandler() {
        Path quarkusLog = LogUtils.resolveQuarkusLogPath();
        String id = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:mdcLogFromException"}).body("Ignored message body").post("/log", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> {
            Map<String, String> mdc = this.parseMdcLogEntries(quarkusLog);
            if (mdc.isEmpty()) {
                return false;
            }
            Assertions.assertEquals((Object)id, (Object)mdc.get("camel.breadcrumbId"));
            Assertions.assertEquals((Object)"mdc-logging", (Object)mdc.get("camel.contextId"));
            Assertions.assertEquals((Object)id, (Object)mdc.get("camel.exchangeId"));
            Assertions.assertEquals((Object)id, (Object)mdc.get("camel.messageId"));
            Assertions.assertTrue((boolean)mdc.get("message").contains("Caught exception"));
            Assertions.assertEquals((Object)"mdc-log-from-exception", (Object)mdc.get("camel.routeId"));
            return true;
        });
    }

    private Map<String, String> parseMdcLogEntries(Path quarkusLog) throws IOException {
        HashMap<String, String> mdc = new HashMap<String, String>();
        Files.readAllLines(quarkusLog).stream().forEach(line -> {
            Matcher matcher = MDC_LOG_PATTERN.matcher((CharSequence)line);
            if (matcher.matches()) {
                String mdcElements = matcher.group(1);
                for (String element : mdcElements.split(",")) {
                    String[] mdcKeyValue = element.split("=");
                    if (mdcKeyValue.length != 2) continue;
                    mdc.put(mdcKeyValue[0].trim(), mdcKeyValue[1].trim());
                }
                mdc.put("message", matcher.group(2));
            }
        });
        return mdc;
    }
}

