/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.log.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.quarkus.component.log.it.LogUtils;
import org.apache.camel.quarkus.main.events.AfterStart;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
@Path(value="/log")
public class LogResource {
    @Inject
    ProducerTemplate producerTemplate;
    @ConfigProperty(name="quarkus.http.test-port")
    Optional<Integer> httpTestPort;
    @ConfigProperty(name="quarkus.http.port")
    Optional<Integer> httpPort;

    private int getEffectivePort() {
        Optional<Integer> portSource = LogUtils.isNativeMode() ? this.httpPort : this.httpTestPort;
        return portSource.orElse(0);
    }

    public void afterApplicationStartup(@Observes AfterStart event) {
        try {
            Files.writeString(LogUtils.resolveQuarkusLogPath(), (CharSequence)("Listening on: http://0.0.0.0:" + this.getEffectivePort() + System.lineSeparator()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @jakarta.enterprise.inject.Produces
    @Named(value="mdcLog")
    LogComponent logComponent() {
        LogComponent logComponent = new LogComponent();
        logComponent.setCamelContext(this.producerTemplate.getCamelContext());
        return logComponent;
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String logMessage(@QueryParam(value="endpointUri") String endpointUri, String message) {
        Exchange result = this.producerTemplate.request(endpointUri, exchange -> exchange.getMessage().setBody((Object)message));
        return result.getExchangeId();
    }
}

