/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.leveldb.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.common.mapper.TypeRef;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.quarkus.component.leveldb.it.LeveldbResource;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class LeveldbTest {
    LeveldbTest() {
    }

    @Test
    public void testAggregate() {
        Map<String, List<Map<String, Object>>> data = this.testAggregate("direct:start", Arrays.asList("S", "H", "E", "L", "D", "O", "N"));
        List<Map<String, Object>> resultData = data.get("mock:result");
        Assertions.assertEquals((Object)"direct://start", (Object)resultData.get(0).get(LeveldbResource.PARAMETER_FROM_ENDPOINT));
    }

    @Test
    public void testAggregateRecovery() {
        Map<String, List<Map<String, Object>>> data = this.testAggregate("direct:startWithFailure", Arrays.asList("S", "H", "E", "L", "D", "O", "N"));
        List<Map<String, Object>> resultData = data.get("mock:result");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)resultData.get(0).get("CamelRedelivered"));
        Assertions.assertEquals((Object)2, (Object)resultData.get(0).get("CamelRedeliveryCounter"));
        Assertions.assertEquals((Object)"direct://startWithFailure", (Object)resultData.get(0).get(LeveldbResource.PARAMETER_FROM_ENDPOINT));
    }

    @Test
    public void testDeadLetter() {
        Map<String, List<Map<String, Object>>> data = this.testAggregate("direct:startDeadLetter", Arrays.asList("S", "H", "E", "L", "D", "O", "N"), "mock:dead,mock:result,mock:aggregated");
        List<Map<String, Object>> deadData = data.get("mock:dead");
        List<Map<String, Object>> resultData = data.get("mock:result");
        List<Map<String, Object>> agreggatedData = data.get("mock:aggregated");
        Assertions.assertTrue((boolean)resultData.isEmpty());
        Assertions.assertFalse((boolean)agreggatedData.get(0).containsKey("CamelRedelivered"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)agreggatedData.get(1).containsKey("CamelRedelivered"));
        Assertions.assertEquals((Object)1, (Object)agreggatedData.get(1).get("CamelRedeliveryCounter"));
        Assertions.assertEquals((Object)3, (Object)agreggatedData.get(1).get("CamelRedeliveryMaxCounter"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)agreggatedData.get(2).containsKey("CamelRedelivered"));
        Assertions.assertEquals((Object)2, (Object)agreggatedData.get(2).get("CamelRedeliveryCounter"));
        Assertions.assertEquals((Object)3, (Object)agreggatedData.get(2).get("CamelRedeliveryMaxCounter"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)agreggatedData.get(3).containsKey("CamelRedelivered"));
        Assertions.assertEquals((Object)3, (Object)agreggatedData.get(3).get("CamelRedeliveryCounter"));
        Assertions.assertEquals((Object)3, (Object)agreggatedData.get(3).get("CamelRedeliveryMaxCounter"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)deadData.get(0).containsKey("CamelRedelivered"));
        Assertions.assertEquals((Object)3, (Object)deadData.get(0).get("CamelRedeliveryCounter"));
        Assertions.assertFalse((boolean)deadData.get(0).containsKey("CamelRedeliveryMaxCounter"));
    }

    @Test
    public void testBinaryData() {
        boolean theSame = (Boolean)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(Arrays.asList("ab", "Sheldon", "cde")).post("/leveldb/aggregateBinary", new Object[0])).then()).statusCode(201)).extract().as(Boolean.class);
        Assertions.assertTrue((boolean)theSame);
    }

    private Map<String, List<Map<String, Object>>> testAggregate(String path, List<String> messages) {
        return this.testAggregate(path, messages, null);
    }

    private Map<String, List<Map<String, Object>>> testAggregate(String path, List<String> messages, String mocks) {
        RequestSpecification rs = RestAssured.given().queryParam("path", new Object[]{path});
        if (mocks != null) {
            rs = rs.queryParam("mocks", new Object[]{mocks});
        }
        return (Map)((ValidatableResponse)((ValidatableResponse)((Response)rs.contentType(ContentType.JSON).body(messages).post("/leveldb/aggregate", new Object[0])).then()).statusCode(201)).extract().as((TypeRef)new TypeRef<Map<String, List<Map<String, Object>>>>(){});
    }

    @AfterAll
    public static void afterAll() throws Exception {
        File data = new File("target/data");
        FileUtils.deleteDirectory((File)data);
    }

    static byte[] readBytes(InputStream is) throws Exception {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        return os.toByteArray();
    }
}

