/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.leveldb.it;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.quarkus.component.leveldb.QuarkusLevelDBAggregationRepository;
import org.apache.camel.spi.AggregationRepository;

public class LeveldbRouteBuilder
extends RouteBuilder {
    public static final String DIRECT_START = "direct:start";
    public static final String DIRECT_BINARY = "direct:binary";
    public static final String DIRECT_START_WITH_FAILURE = "direct:startWithFailure";
    public static final String DIRECT_START_DEAD_LETTER = "direct:startDeadLetter";
    public static final String MOCK_AGGREGATED = "mock:aggregated";
    public static final String MOCK_RESULT = "mock:result";
    public static final String MOCK_DEAD = "mock:dead";
    public static final String DATA_FOLDER = "target/data";
    private static AtomicInteger counter = new AtomicInteger(0);

    public void configure() {
        QuarkusLevelDBAggregationRepository repo = new QuarkusLevelDBAggregationRepository("repo", "target/dataleveldb.dat");
        this.from(DIRECT_START).aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).completionSize(7).aggregationRepository((AggregationRepository)repo).to(MOCK_RESULT);
        QuarkusLevelDBAggregationRepository repoBinary = new QuarkusLevelDBAggregationRepository("repo", "target/datalevelBinarydb.dat");
        this.from(DIRECT_BINARY).aggregate((Expression)this.header("id"), (AggregationStrategy)new BinaryAggregationStrategy()).completionSize(3).aggregationRepository((AggregationRepository)repoBinary).to(MOCK_RESULT);
        QuarkusLevelDBAggregationRepository repoWithFailure = new QuarkusLevelDBAggregationRepository("repoWithFailure", "target/dataleveldbWithFailure.dat");
        repoWithFailure.setUseRecovery(true);
        repoWithFailure.setRecoveryInterval(500L, TimeUnit.MILLISECONDS);
        ((AggregateDefinition)((AggregateDefinition)((AggregateDefinition)this.from(DIRECT_START_WITH_FAILURE).aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).completionSize(7).aggregationRepository((AggregationRepository)repoWithFailure).to(MOCK_AGGREGATED)).process(exchange -> {
            int count = counter.incrementAndGet();
            if (count <= 2) {
                throw new IllegalArgumentException("Failure");
            }
        })).to(MOCK_RESULT)).end();
        QuarkusLevelDBAggregationRepository repoDeadLetter = new QuarkusLevelDBAggregationRepository("repoDeadLetter", "target/dataleveldbDeadLetter.dat");
        repoDeadLetter.setUseRecovery(true);
        repoDeadLetter.setRecoveryInterval(500L, TimeUnit.MILLISECONDS);
        repoDeadLetter.setMaximumRedeliveries(3);
        repoDeadLetter.setDeadLetterUri(MOCK_DEAD);
        ((AggregateDefinition)((AggregateDefinition)((AggregateDefinition)((AggregateDefinition)this.from(DIRECT_START_DEAD_LETTER).aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).completionSize(7).aggregationRepository((AggregationRepository)repoDeadLetter).to(MOCK_AGGREGATED)).process(e -> {
            throw new IllegalArgumentException("Failure");
        })).log("XXX: result exchange id ${exchangeId} with ${body}")).to(MOCK_RESULT)).end();
    }

    public static class BinaryAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            byte[] body1 = (byte[])oldExchange.getIn().getBody(byte[].class);
            byte[] body2 = (byte[])newExchange.getIn().getBody(byte[].class);
            oldExchange.getIn().setBody((Object)(body1.length > body2.length ? body1 : body2));
            return oldExchange;
        }
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body1 + "+" + body2));
            return oldExchange;
        }
    }
}

