/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.leveldb.it;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;

@Path(value="/leveldb")
@ApplicationScoped
public class LeveldbResource {
    public static String PARAMETER_BODY = "body";
    public static String PARAMETER_FROM_ENDPOINT = "fromEndpoint";
    public static String MOCKS_DELIMITER = ",";
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/aggregate")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response aggregateTest(List<String> messages, @QueryParam(value="path") String path, @DefaultValue(value="mock:result") @QueryParam(value="mocks") String mockNames) throws Exception {
        String[] mockNamesArray = mockNames.split(MOCKS_DELIMITER);
        MockEndpoint[] mocks = new MockEndpoint[mockNamesArray.length];
        for (int i = 0; i < mocks.length; ++i) {
            mocks[i] = (MockEndpoint)this.context.getEndpoint(mockNamesArray[i], MockEndpoint.class);
            mocks[i].reset();
            if (i != 0) continue;
            mocks[i].expectedBodiesReceived(new Object[]{((Stream)messages.stream().sequential()).collect(Collectors.joining("+"))});
        }
        for (String message : messages) {
            this.producerTemplate.sendBodyAndHeader(path, (Object)message, "id", (Object)123);
        }
        MockEndpoint.assertIsSatisfied((CamelContext)this.context, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        HashMap<String, List<Map<String, Object>>> data = new HashMap<String, List<Map<String, Object>>>();
        for (int i = 0; i < mocks.length; ++i) {
            data.put(mockNamesArray[i], this.extractDataFromMock(mocks[i]));
        }
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(data).build();
    }

    @Path(value="/aggregateBinary")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response aggregateBinaryTest(String[] messages) throws Exception {
        MockEndpoint mockResult = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        mockResult.reset();
        mockResult.setExpectedMessageCount(1);
        byte[] longestBytes = messages[0].getBytes();
        for (String message : messages) {
            byte[] b = message.getBytes();
            this.producerTemplate.sendBodyAndHeader("direct:binary", (Object)message.getBytes(), "id", (Object)123);
            if (b.length <= longestBytes.length) continue;
            longestBytes = b;
        }
        MockEndpoint.assertIsSatisfied((CamelContext)this.context, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        byte[] result = (byte[])((Exchange)mockResult.getExchanges().get(0)).getIn().getBody(byte[].class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)Arrays.equals(longestBytes, result)).build();
    }

    private List<Map<String, Object>> extractDataFromMock(MockEndpoint mockEndpoint) {
        List<Map<String, Object>> data = ((Stream)mockEndpoint.getReceivedExchanges().stream().sequential()).map(exchange -> {
            HashMap<String, String> map = new HashMap<String, String>(exchange.getIn().getHeaders());
            map.put(PARAMETER_FROM_ENDPOINT, exchange.getFromEndpoint().getEndpointUri());
            map.put(PARAMETER_BODY, String.valueOf(exchange.getIn().getBody()));
            return map;
        }).collect(Collectors.toList());
        return data;
    }
}

