/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ldap.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.ldap.LdapHelper;
import org.apache.camel.quarkus.component.ldap.it.CustomSSLSocketFactory;

@Path(value="/ldap")
@ApplicationScoped
public class LdapResource {
    @Inject
    CamelContext camelContext;
    private String ldapHost;
    private String ldapPort;
    private boolean useSSL;
    private String trustStoreFilename;
    private String trustStorePassword;

    @Path(value="/configure")
    @POST
    @Consumes(value={"application/json"})
    public void configure(Map<String, String> options) throws Exception {
        this.ldapHost = options.get("host");
        this.ldapPort = options.get("port");
        this.useSSL = Boolean.valueOf(options.get("ssl"));
        this.trustStoreFilename = options.get("trustStore");
        this.trustStorePassword = options.get("trustStorePassword");
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    public Response search(@QueryParam(value="ldapQuery") String ldapQuery) throws Exception {
        return Response.ok(this.searchByUid(ldapQuery)).build();
    }

    @Path(value="/safeSearch")
    @GET
    @Produces(value={"application/json"})
    public Response safeSearch(@QueryParam(value="ldapQuery") String ldapQuery) throws Exception {
        return Response.ok(this.searchByUid(LdapHelper.escapeFilter((String)ldapQuery))).build();
    }

    private List<Map<String, String>> searchByUid(String uid) throws Exception {
        String filter = String.format("(uid=%s)", uid);
        ProducerTemplate producer = this.camelContext.createProducerTemplate();
        List results = (List)producer.requestBody("direct:start", (Object)filter, List.class);
        return this.convertSearchResults(results);
    }

    @Produces
    @Dependent
    @Named(value="ldapserver")
    public DirContext createLdapContext() throws Exception {
        String scheme = this.useSSL ? "ldaps" : "ldap";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", String.format("%s://%s:%s", scheme, this.ldapHost, this.ldapPort));
        env.put("java.naming.security.authentication", "none");
        if (this.useSSL) {
            CustomSSLSocketFactory.setTrustStore(this.trustStoreFilename, this.trustStorePassword);
            env.put("java.naming.ldap.factory.socket", CustomSSLSocketFactory.class.getName());
            env.put("java.naming.security.protocol", "ssl");
        }
        return new InitialDirContext(env);
    }

    private List<Map<String, String>> convertSearchResults(List<SearchResult> searchResults) throws Exception {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        for (SearchResult searchResult : searchResults) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            NamingEnumeration<? extends Attribute> attrs = searchResult.getAttributes().getAll();
            while (attrs.hasMore()) {
                Attribute attr = attrs.next();
                resultMap.put(attr.getID(), attr.get().toString());
            }
            results.add(resultMap);
        }
        return results;
    }
}

