/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ldap.it;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.common.mapper.TypeRef;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLServerSocketFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class LdapTest {
    private static InMemoryDirectoryServer ldapServer = null;
    private static final String truststoreFile = "target/test-classes/truststore.jks";

    LdapTest() {
    }

    @BeforeAll
    public static void setUpLdapServer() throws Exception {
        InMemoryDirectoryServerConfig dsConfig = new InMemoryDirectoryServerConfig(new String[]{"ou=system"});
        InMemoryListenerConfig listenerConfig = InMemoryListenerConfig.createLDAPConfig((String)"ldap", (InetAddress)InetAddress.getLoopbackAddress(), (int)0, null);
        Path keystoreFile = Paths.get("target/test-classes/keystore.jks", new String[0]);
        if (!Files.isRegularFile(keystoreFile, new LinkOption[0])) {
            Files.createDirectories(keystoreFile.getParent(), new FileAttribute[0]);
            try (InputStream in = LdapTest.class.getClassLoader().getResourceAsStream(keystoreFile.getFileName().toString());){
                Files.copy(in, keystoreFile, new CopyOption[0]);
            }
            Path truststorePath = Paths.get(truststoreFile, new String[0]);
            try (InputStream in = LdapTest.class.getClassLoader().getResourceAsStream(truststorePath.getFileName().toString());){
                Files.copy(in, truststorePath, new CopyOption[0]);
            }
        }
        SSLUtil serverSSLUtil = new SSLUtil((KeyManager)new KeyStoreKeyManager(keystoreFile.toFile(), "ldapPass".toCharArray()), null);
        InMemoryListenerConfig sslListenerConfig = InMemoryListenerConfig.createLDAPSConfig((String)"ldaps", (InetAddress)InetAddress.getLoopbackAddress(), (int)0, (SSLServerSocketFactory)serverSSLUtil.createSSLServerSocketFactory(), null);
        dsConfig.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig, sslListenerConfig});
        ldapServer = new InMemoryDirectoryServer(dsConfig);
        LDIFReader ldifReader = new LDIFReader(LdapTest.class.getClassLoader().getResourceAsStream("LdapRouteTest.ldif"));
        ldapServer.importFromLDIF(true, ldifReader);
        ldapServer.startListening();
    }

    @AfterAll
    public static void tearDownLdapServer() {
        if (ldapServer != null) {
            ldapServer.close();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void ldapSearchTest(boolean useSSL) throws Exception {
        this.configureResource(useSSL);
        TypeRef<List<Map<String, Object>>> typeRef = new TypeRef<List<Map<String, Object>>>(){};
        List results = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("ldapQuery", new Object[]{"tcruise"}).get("/ldap/search", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)typeRef);
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)"Tom Cruise", ((Map)results.get(0)).get("cn"));
    }

    @Test
    public void ldapHelperTest() throws Exception {
        this.configureResource(false);
        TypeRef<List<Map<String, Object>>> typeRef = new TypeRef<List<Map<String, Object>>>(){};
        List results = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("ldapQuery", new Object[]{"test*"}).get("/ldap/search", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)typeRef);
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertEquals(List.of("test1", "test2", "testNoOU"), results.stream().map(r -> r.get("uid")).collect(Collectors.toList()));
        results = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("ldapQuery", new Object[]{"test*"}).get("/ldap/safeSearch", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)typeRef);
        Assertions.assertEquals((int)0, (int)results.size());
        results = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("ldapQuery", new Object[]{"test1"}).get("/ldap/safeSearch", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)typeRef);
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)"test1", ((Map)results.get(0)).get("ou"));
    }

    private void configureResource(boolean useSSL) throws Exception {
        String listenerName = useSSL ? "ldaps" : "ldap";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("host", ldapServer.getListenAddress(listenerName).getHostAddress());
        options.put("port", String.valueOf(ldapServer.getListenPort(listenerName)));
        options.put("ssl", String.valueOf(useSSL));
        if (useSSL) {
            options.put("trustStore", truststoreFile);
            options.put("trustStorePassword", "ldapPass");
        }
        ((ValidatableResponse)((Response)RestAssured.given().body(options).contentType("application/json").post("/ldap/configure", new Object[0])).then()).statusCode(204);
    }
}

