/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ldap.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.ldap.LdapHelper;
import org.apache.camel.quarkus.component.ldap.it.CustomSSLSocketFactory;

@Path(value="/ldap")
@ApplicationScoped
public class LdapResource {
    @Inject
    CamelContext camelContext;

    @Path(value="/configure")
    @POST
    @Consumes(value={"application/json"})
    public void configure(Map<String, String> options) throws Exception {
        String host = options.get("host");
        String port = options.get("port");
        boolean useSSL = Boolean.valueOf(options.get("ssl"));
        String trustStoreFilename = options.get("trustStore");
        String trustStorePassword = options.get("trustStorePassword");
        DirContext dirContext = this.createLdapContext(host, port, useSSL, trustStoreFilename, trustStorePassword);
        this.camelContext.getRegistry().bind("ldapserver", (Object)dirContext);
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    public Response search(@QueryParam(value="q") String filter) throws Exception {
        ProducerTemplate producer = this.camelContext.createProducerTemplate();
        List results = (List)producer.requestBody("direct:start", (Object)filter, List.class);
        return Response.ok(this.convertSearchResults(results)).build();
    }

    @Path(value="/safeSearch")
    @GET
    @Produces(value={"application/json"})
    public Response safeSearch(@QueryParam(value="q") String unsafeFilter) throws Exception {
        String filter = String.format("(ou=%s)", LdapHelper.escapeFilter((String)unsafeFilter));
        ProducerTemplate producer = this.camelContext.createProducerTemplate();
        List results = (List)producer.requestBody("direct:start", (Object)filter, List.class);
        return Response.ok(this.convertSearchResults(results)).build();
    }

    private DirContext createLdapContext(String host, String port, boolean useSSL, String trustStoreFilename, String trustStorePassword) throws Exception {
        String scheme = useSSL ? "ldaps" : "ldap";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", String.format("%s://%s:%s", scheme, host, port));
        env.put("java.naming.security.authentication", "none");
        if (useSSL) {
            CustomSSLSocketFactory.setTrustStore(trustStoreFilename, trustStorePassword);
            env.put("java.naming.ldap.factory.socket", CustomSSLSocketFactory.class.getName());
            env.put("java.naming.security.protocol", "ssl");
        }
        return new InitialDirContext(env);
    }

    private List<Map<String, String>> convertSearchResults(List<SearchResult> searchResults) throws Exception {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        for (SearchResult searchResult : searchResults) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            NamingEnumeration<? extends Attribute> attrs = searchResult.getAttributes().getAll();
            while (attrs.hasMore()) {
                Attribute attr = attrs.next();
                resultMap.put(attr.getID(), attr.get().toString());
            }
            results.add(resultMap);
        }
        return results;
    }
}

