/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.language.it;

import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.Scanner;

@RegisterForReflection(targets={Scanner.class})
public class LanguageRoutes
extends RouteBuilder {
    @Inject
    CamelContext context;

    public void configure() throws Exception {
        this.from("direct:languageBeanScript").to("language://bean:org.apache.camel.quarkus.component.language.it.CaseConverter::toUpper");
        this.from("direct:languageConstantScript").to("language://constant:Hello from constant language script");
        ((RouteDefinition)this.from("direct:languageExchangePropertyScript").setProperty("testProperty", (Expression)this.simple("Hello ${body} from exchangeProperty language script"))).to("language://exchangeProperty:testProperty");
        ((RouteDefinition)this.from("file:target?fileName=test-file.txt&noop=true").to("language://file:File name is ${file:onlyname}")).to("direct:languageFileOutput");
        ((RouteDefinition)this.from("direct:languageHeaderScript").setHeader("testHeader", (Expression)this.simple("Hello ${body} from header language script"))).to("language://header:testHeader");
        ((RouteDefinition)this.from("direct:languageHl7terserScript").to("language://hl7terser:PID-5")).setBody((Expression)this.simple("Patient's surname is ${body}"));
        this.from("direct:languageJsonPathScript").to("language://jsonpath:$.message");
        this.from("direct:languageRefScript").to("language://ref:lowerCase");
        this.from("direct:languageSimpleScript").to("language://simple:Hello ${body} from simple language script");
        ((RouteDefinition)this.from("direct:languageTokenizeScript").to("language://tokenize:,")).setBody((Expression)this.simple("${body.next()}"));
        this.from("direct:languageXpathScript").to("language://xpath:/message/text()");
        this.from("direct:languageXqueryScript").to("language://xquery:upper-case(/message/text())?resultType=String");
        this.from("direct:languageSimpleResource").to("language://simple:resource:hello.simple-res.txt");
        this.from("direct:languageSimpleFile").to("language://simple:file:target/hello.simple-file.txt");
        this.from("direct:languageSimpleTransform").to("language://simple:Hello ${body}!?transform=false");
    }
}

