/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.language.it;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.quarkus.component.language.it.LanguageTestResource;
import org.apache.camel.quarkus.test.wiremock.MockServer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@QuarkusTest
@QuarkusTestResource(value=LanguageTestResource.class)
class LanguageTest {
    @MockServer
    WireMockServer server;
    private static Map<String, TestResult> languageResultsMap = Map.ofEntries(Map.entry("languageBeanScript", new TestResult("Hello Bean", "HELLO BEAN")), Map.entry("languageConstantScript", new TestResult("Constant", "Hello from constant language script")), Map.entry("languageExchangePropertyScript", new TestResult("ExProperty", "Hello ExProperty from exchangeProperty language script")), Map.entry("languageFileScript", new TestResult("", "File name is test-file.txt")), Map.entry("languageHeaderScript", new TestResult("Header", "Hello Header from header language script")), Map.entry("languageHl7terserScript", new TestResult(LanguageTest.createHl7Message(), "Patient's surname is Smith")), Map.entry("languageJsonPathScript", new TestResult("{\"message\": \"Hello from jsonpath\", \"user\": \"camel-quarkus\"}", "Hello from jsonpath")), Map.entry("languageRefScript", new TestResult("Hello from Ref", "hello from ref")), Map.entry("languageSimpleScript", new TestResult("Simple", "Hello Simple from simple language script")), Map.entry("languageTokenizeScript", new TestResult("Hello,Tokenize", "Hello")), Map.entry("languageXpathScript", new TestResult("<message>Hello from Xpath</message>", "Hello from Xpath")), Map.entry("languageXqueryScript", new TestResult("<message>Hello from XQuery</message>", "HELLO FROM XQUERY")), Map.entry("languageSimpleResource", new TestResult("SimpleRes", "Hello SimpleRes from simple language resource")), Map.entry("languageSimpleFile", new TestResult("SimpleFile", "Hello SimpleFile from simple language file")), Map.entry("languageSimpleTransform", new TestResult("SimpleTransform", "SimpleTransform")));
    private static final String OUTPUT_DIRECTORY = "target";
    private static final String TEST_FILE = "test-file.txt";
    private static final String SIMPLE_FILE = "hello.simple-file.txt";

    LanguageTest() {
    }

    /*
     * Exception decompiling
     */
    private static Collection<Object[]> getLanguageResultsMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @BeforeAll
    public static void setupTestFiles() throws Exception {
        Files.createDirectories(Paths.get(OUTPUT_DIRECTORY, new String[0]), new FileAttribute[0]);
        Files.writeString(Paths.get(OUTPUT_DIRECTORY, TEST_FILE), (CharSequence)"Dummy text", StandardCharsets.UTF_8, new OpenOption[0]);
        Files.copy(LanguageTest.class.getClassLoader().getResourceAsStream(SIMPLE_FILE), Paths.get(OUTPUT_DIRECTORY, SIMPLE_FILE), StandardCopyOption.REPLACE_EXISTING);
    }

    @AfterAll
    public static void deleteTestFiles() throws Exception {
        Files.delete(Paths.get(OUTPUT_DIRECTORY, TEST_FILE));
        Files.delete(Paths.get(OUTPUT_DIRECTORY, SIMPLE_FILE));
    }

    @ParameterizedTest
    @MethodSource(value={"getLanguageResultsMap"})
    public void testLanguage(String routeName, TestResult result) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(result.body).post("/language/route/" + routeName, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)result.expected), new Matcher[0]);
    }

    @Test
    public void testHttpResource() throws Exception {
        Assertions.assertNotNull((Object)this.server);
        this.server.stubFor(WireMock.request((String)"GET", (UrlPattern)WireMock.urlPathEqualTo((String)"/simple")).willReturn(WireMock.aResponse().withBody("Hello ${body} from simple language http")));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("baseUrl", new Object[]{this.server.baseUrl()}).contentType(ContentType.TEXT).body("SimpleHttp").post("/language/route/languageSimpleHttp", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello SimpleHttp from simple language http"), new Matcher[0]);
        this.server.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/simple")));
    }

    @Test
    public void testContentCache() {
        Assertions.assertNotNull((Object)this.server);
        this.server.stubFor(WireMock.request((String)"GET", (UrlPattern)WireMock.urlPathEqualTo((String)"/simpleContentCache")).willReturn(WireMock.aResponse().withBody("Hello ${body} from simple language http")));
        RequestSpecBuilder builder = new RequestSpecBuilder();
        builder.addQueryParam("baseUrl", new Object[]{this.server.baseUrl()});
        builder.setContentType(ContentType.TEXT);
        builder.setBody("SimpleHttp");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(builder.build()).queryParam("contentCache", new Object[]{true}).when().post("/language/route/languageSimpleContentCache", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello SimpleHttp from simple language http"), new Matcher[0]);
        this.server.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/simpleContentCache")));
        ((ValidatableResponse)((Response)RestAssured.given().spec(builder.build()).queryParam("contentCache", new Object[]{true}).when().post("/language/route/languageSimpleContentCache", new Object[0])).then()).statusCode(200);
        this.server.verify(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/simpleContentCache")));
        ((ValidatableResponse)((Response)RestAssured.given().spec(builder.build()).queryParam("contentCache", new Object[]{false}).when().post("/language/route/languageSimpleContentCache", new Object[0])).then()).statusCode(200);
        this.server.verify(2, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/simpleContentCache")));
    }

    private static String createHl7Message() {
        return "MSH|^~\\&|||||20230221140012.386+0000||ADT^A01^ADT_A01|601|P|2.4\rPID|||1||Smith^John";
    }

    private static class TestResult {
        String body;
        String expected;

        public TestResult(String body, String expected) {
            this.body = body;
            this.expected = expected;
        }
    }
}

