/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.language.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;

@Path(value="/language")
@ApplicationScoped
public class LanguageResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/route/{route}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String route(String body, @PathParam(value="route") String route) {
        return (String)this.producerTemplate.requestBody("direct:" + route, (Object)body, String.class);
    }

    @Path(value="/route/languageFileScript")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String routeFileScript(String body) {
        return (String)this.consumerTemplate.receiveBody("direct:languageFileOutput", 5000L, String.class);
    }

    @Path(value="/route/languageSimpleHttp")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String routeSimpleHttp(String body, @QueryParam(value="baseUrl") String baseUrl) {
        return (String)this.producerTemplate.requestBody("language:simple:resource:" + baseUrl + "/simple", (Object)body, String.class);
    }

    @Path(value="/route/languageSimpleContentCache")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String routeSimpleContentCache(String body, @QueryParam(value="baseUrl") String baseUrl, @QueryParam(value="contentCache") String contentCache) {
        String option = "?contentCache=" + contentCache;
        String url = "language:simple:resource:" + baseUrl + "/simpleContentCache" + option;
        return (String)this.producerTemplate.requestBody(url, (Object)body, String.class);
    }
}

