/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kudu.it;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class KuduTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = LoggerFactory.getLogger(KuduTestResource.class);
    private static final int KUDU_MASTER_RPC_PORT = 7051;
    private static final int KUDU_MASTER_HTTP_PORT = 8051;
    private static final int KUDU_TABLET_RPC_PORT = 7050;
    private static final int KUDU_TABLET_HTTP_PORT = 8050;
    private static final String KUDU_IMAGE = "apache/kudu:1.12.0";
    private static final String KUDU_MASTER_NETWORK_ALIAS = "kudu-master";
    private static final String KUDU_TABLET_NETWORK_ALIAS = "kudu-tserver";
    private GenericContainer masterContainer;
    private GenericContainer tabletContainer;

    public Map<String, String> start() {
        LOG.info(TestcontainersConfiguration.getInstance().toString());
        try {
            Network kuduNetwork = Network.newNetwork();
            this.masterContainer = new GenericContainer(KUDU_IMAGE).withCommand("master").withExposedPorts(new Integer[]{7051, 8051}).withNetwork(kuduNetwork).withNetworkAliases(new String[]{KUDU_MASTER_NETWORK_ALIAS});
            this.masterContainer = this.masterContainer.withLogConsumer((Consumer)new Slf4jLogConsumer(LOG)).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.masterContainer.start();
            Consumer<CreateContainerCmd> consumer = cmd -> {
                Ports portBindings = new Ports();
                portBindings.bind(ExposedPort.tcp((int)7050), Ports.Binding.bindPort((int)7050));
                portBindings.bind(ExposedPort.tcp((int)8050), Ports.Binding.bindPort((int)8050));
                HostConfig hostConfig = HostConfig.newHostConfig().withPortBindings(portBindings).withNetworkMode(kuduNetwork.getId());
                cmd.withHostName(KUDU_TABLET_NETWORK_ALIAS).withHostConfig(hostConfig);
            };
            this.tabletContainer = new GenericContainer(KUDU_IMAGE).withCommand("tserver").withEnv("KUDU_MASTERS", KUDU_MASTER_NETWORK_ALIAS).withExposedPorts(new Integer[]{7050, 8050}).withNetwork(kuduNetwork).withNetworkAliases(new String[]{KUDU_TABLET_NETWORK_ALIAS}).withCreateContainerCmdModifier(consumer);
            this.tabletContainer = this.tabletContainer.withLogConsumer((Consumer)new Slf4jLogConsumer(LOG)).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.tabletContainer.start();
            String masterRpcAuthority = this.masterContainer.getContainerIpAddress() + ":" + this.masterContainer.getMappedPort(7051);
            LOG.info("Kudu master RPC accessible at " + masterRpcAuthority);
            String masterHttpAuthority = this.masterContainer.getContainerIpAddress() + ":" + this.masterContainer.getMappedPort(8051);
            LOG.info("Kudu master HTTP accessible at " + masterHttpAuthority);
            String tServerRpcAuthority = this.tabletContainer.getContainerIpAddress() + ":" + this.tabletContainer.getMappedPort(7050);
            LOG.info("Kudu tablet server RPC accessible at " + tServerRpcAuthority);
            String tServerHttpAuthority = this.tabletContainer.getContainerIpAddress() + ":" + this.tabletContainer.getMappedPort(8050);
            LOG.info("Kudu tablet server HTTP accessible at " + tServerHttpAuthority);
            return CollectionHelper.mapOf((Object)"camel.kudu.test.master.rpc-authority", (Object)masterRpcAuthority, (Object[])new Object[0]);
        }
        catch (Exception ex) {
            LOG.error("Issue starting KuduTestResource, please have a look at KuduInfrastructureTestHelper", (Throwable)ex);
            return CollectionHelper.mapOf((Object)"camel.kudu.test.master.rpc-authority", (Object)"Please_have_a_look_at_KuduInfrastructureTestHelper", (Object[])new Object[0]);
        }
    }

    public void stop() {
        try {
            if (this.masterContainer != null) {
                this.masterContainer.stop();
            }
            if (this.tabletContainer != null) {
                this.tabletContainer.stop();
            }
        }
        catch (Exception ex) {
            LOG.error("An issue occured while stopping the KuduTestResource", (Throwable)ex);
        }
    }
}

