/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kudu.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.kudu.KuduUtils;
import org.apache.camel.quarkus.component.kudu.it.KuduInfrastructureTestHelper;
import org.apache.camel.quarkus.component.kudu.it.KuduTestResource;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@QuarkusTestResource(value=KuduTestResource.class)
@QuarkusTest
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
class KuduTest {
    private static final Logger LOG = Logger.getLogger(KuduTest.class);
    static String MASTER_RPC_AUTHORITY;

    KuduTest() {
    }

    @BeforeAll
    static void setup() {
        MASTER_RPC_AUTHORITY = (String)ConfigProvider.getConfig().getValue("camel.kudu.test.master.rpc-authority", String.class);
        KuduInfrastructureTestHelper.overrideTabletServerHostnameResolution();
    }

    @Order(value=1)
    @Test
    public void createTableShouldSucceed() throws KuduException {
        LOG.info((Object)"Calling createTableShouldSucceed");
        KuduClient client = new KuduClient.KuduClientBuilder(MASTER_RPC_AUTHORITY).build();
        Assertions.assertEquals((int)0, (int)client.getTablesList().getTablesList().size());
        ((ValidatableResponse)RestAssured.put((String)"/kudu/createTable", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertEquals((int)1, (int)client.getTablesList().getTablesList().size());
    }

    @Order(value=2)
    @Test
    public void insertShouldSucceed() throws KuduException {
        LOG.info((Object)"Calling insertShouldSucceed");
        ((ValidatableResponse)RestAssured.put((String)"/kudu/insert", (Object[])new Object[0]).then()).statusCode(200);
        KuduClient client = new KuduClient.KuduClientBuilder(MASTER_RPC_AUTHORITY).build();
        List records = KuduUtils.doScan((String)"TestTable", (KuduClient)client);
        Assertions.assertEquals((int)1, (int)records.size());
        Map record = (Map)records.get(0);
        Assertions.assertNotNull((Object)record);
        Assertions.assertEquals((Object)"key1", record.get("id"));
        Assertions.assertEquals((Object)"Samuel", record.get("name"));
    }

    @Order(value=3)
    @Test
    public void scanShouldSucceed() {
        LOG.info((Object)"Calling scanShouldSucceed");
        String record = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/kudu/scan", (Object[])new Object[0]).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)"key1/Samuel", (Object)record);
    }
}

