/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kubernetes.it;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.kubernetes.client.KubernetesServerTestResource;
import io.quarkus.test.kubernetes.client.KubernetesTestServer;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=KubernetesServerTestResource.class)
public class KubernetesTest {
    @KubernetesTestServer
    private KubernetesServer mockServer;

    @Test
    public void testKubernetesComponent() {
        Container container = new Container();
        container.setImage("busybox:latest");
        container.setName("camel-pod");
        Pod pod = ((PodBuilder)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("camel-pod")).withNamespace("test")).and()).withNewSpec().withContainers(new Container[]{container})).and()).build();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.mockServer.expect().post()).withPath("/api/v1/namespaces/test/pods")).andReturn(201, (Object)pod)).once();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.mockServer.expect().get()).withPath("/api/v1/namespaces/test/pods/camel-pod")).andReturn(200, (Object)pod)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.mockServer.expect().delete()).withPath("/api/v1/namespaces/test/pods/camel-pod")).andReturn(200, (Object)"{}")).once();
        ((ValidatableResponse)((Response)RestAssured.when().post("/kubernetes/pod/test/camel-pod", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/kubernetes/pod/test/camel-pod", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"camel-pod"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().delete("/kubernetes/pod/test/camel-pod", new Object[0])).then()).statusCode(204);
    }
}

