/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kubernetes.it;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;

@Path(value="/kubernetes")
@ApplicationScoped
public class KubernetesResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/pod/{namespace}/{podName}")
    @GET
    @Produces(value={"text/plain"})
    public String readPod(@PathParam(value="namespace") String namespace, @PathParam(value="podName") String podName) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKubernetesNamespaceName", namespace);
        headers.put("CamelKubernetesPodName", podName);
        Pod pod = (Pod)this.producerTemplate.requestBodyAndHeaders("kubernetes-pods:///?kubernetesClient=#kubernetesClient&operation=getPod", null, headers, Pod.class);
        return pod.getMetadata().getName();
    }

    @Path(value="/pod/{namespace}/{podName}")
    @POST
    @Produces(value={"text/plain"})
    public Response createPod(@PathParam(value="namespace") String namespace, @PathParam(value="podName") String podName) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKubernetesNamespaceName", namespace);
        headers.put("CamelKubernetesPodName", podName);
        headers.put("CamelKubernetesPodSpec", (String)this.createPodSpec(podName));
        this.producerTemplate.requestBodyAndHeaders("kubernetes-pods:///?kubernetesClient=#kubernetesClient&operation=createPod", null, headers, Pod.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/pod/{namespace}/{podName}")
    @DELETE
    public Response deletePod(@PathParam(value="namespace") String namespace, @PathParam(value="podName") String podName) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKubernetesNamespaceName", namespace);
        headers.put("CamelKubernetesPodName", podName);
        this.producerTemplate.requestBodyAndHeaders("kubernetes-pods:///?kubernetesClient=#kubernetesClient&operation=deletePod", null, headers);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private PodSpec createPodSpec(String containerName) {
        PodSpec podSpec = new PodSpec();
        Container container = new Container();
        container.setImage("docker.io/busybox:latest");
        container.setName(containerName);
        ArrayList<Container> containers = new ArrayList<Container>();
        containers.add(container);
        podSpec.setContainers(containers);
        return podSpec;
    }
}

