/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kamelet.it;

import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.enterprise.context.ApplicationScoped;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

@ApplicationScoped
public class KameletRoutes
extends RouteBuilder {
    public void configure() throws Exception {
        this.routeTemplate("setBody").templateParameter("bodyValue").from("kamelet:source").setBody().constant((Object)"Hello {{bodyValue}}");
        this.routeTemplate("setBodyFromProperties").templateParameter("bodyValueFromProperty").from("kamelet:source").setBody().constant((Object)"Hello {{bodyValueFromProperty}}");
        ((ProcessorDefinition)this.routeTemplate("tick").from("timer:{{routeId}}?repeatCount=1&delay=-1").setBody().exchangeProperty("CamelTimerCounter")).to("kamelet:sink");
        this.routeTemplate("echo").templateParameter("prefix").templateParameter("suffix").from("kamelet:source").setBody().simple("{{prefix}} ${body} {{suffix}}");
        this.routeTemplate("AppendWithBean").templateBean("appender", (Object)new AppenderProcessor()).from("kamelet:source").to("bean:{{appender}}");
        this.routeTemplate("AppendWithClass").templateBean("appender", AppenderProcessor.class).from("kamelet:source").to("bean:{{appender}}");
        ((RouteDefinition)this.from("direct:chain").to("kamelet:echo/1?prefix=Camel Quarkus&suffix=Chained")).to("kamelet:echo/2?prefix=Hello&suffix=Route");
        this.from("direct:kamelet-location-at-runtime").kamelet("upper?location=classpath:kamelets-runtime/upper-kamelet.xml");
    }

    @RegisterForReflection
    public static class AppenderProcessor
    implements Processor {
        public void process(Exchange exchange) {
            exchange.getMessage().setBody((Object)((String)exchange.getMessage().getBody(String.class) + "-suffix"));
        }
    }

    @RegisterForReflection(fields=false, targets={String.class})
    public static class StringUpperCaseReflectionForUpperKamelet {
    }
}

