/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kamelet.it;

import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.model.Model;
import org.apache.camel.model.OptionalIdentifiedDefinition;

@Path(value="/kamelet")
public class KameletResource {
    @Inject
    CamelContext camelContext;
    @Inject
    FluentProducerTemplate fluentProducerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/produce")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String produceToKamelet(String message) throws Exception {
        return (String)this.fluentProducerTemplate.toF("kamelet:setBody/test?bodyValue=%s", new Object[]{message}).request(String.class);
    }

    @Path(value="/consume")
    @GET
    @Produces(value={"text/plain"})
    public Integer consumeFromKamelet() throws Exception {
        return (Integer)this.consumerTemplate.receiveBody("kamelet:tick", 10000L, Integer.class);
    }

    @Path(value="/property")
    @GET
    @Produces(value={"text/plain"})
    public String bodyFromProperty() throws Exception {
        return (String)this.fluentProducerTemplate.to("kamelet:setBodyFromProperties").request(String.class);
    }

    @Path(value="/chain")
    @POST
    @Produces(value={"text/plain"})
    public String kameletChain(String message) throws Exception {
        return (String)this.fluentProducerTemplate.to("direct:chain").withBody((Object)message).request(String.class);
    }

    @Path(value="/invoke/{name}")
    @POST
    @Produces(value={"text/plain"})
    public String invoke(@PathParam(value="name") String name, String message) throws Exception {
        return (String)this.fluentProducerTemplate.toF("kamelet:%s", new Object[]{name}).withBody((Object)message).request(String.class);
    }

    @Path(value="/list")
    @GET
    @Produces(value={"application/json"})
    public JsonArray list() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        ((Model)this.camelContext.getCamelContextExtension().getContextPlugin(Model.class)).getRouteTemplateDefinitions().stream().map(OptionalIdentifiedDefinition::getId).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return builder.build();
    }

    @Path(value="/locationAtRuntime/{name}")
    @POST
    @Produces(value={"text/plain"})
    public String kameletLocationAtRuntime(@PathParam(value="name") String name) {
        return (String)this.fluentProducerTemplate.to("direct:kamelet-location-at-runtime").withBody((Object)name).request(String.class);
    }
}

