/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kamelet.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class KameletTest {
    KameletTest() {
    }

    @Test
    public void testKameletProducing() {
        String message = "Camel Quarkus Kamelet";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/kamelet/produce", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + message)), new Matcher[0]);
    }

    @Test
    public void testKameletConsuming() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/kamelet/consume", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
    }

    @Test
    public void testKameletWithProperties() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/kamelet/property", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Kamelet Property"), new Matcher[0]);
    }

    @Test
    public void testKameletChain() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kamelet").post("/kamelet/chain", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Kamelet Chained Route"), new Matcher[0]);
    }

    @Test
    public void testInvoke() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kamelet").post("/kamelet/invoke/AppendWithBean", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Kamelet-suffix"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kamelet2").post("/kamelet/invoke/AppendWithClass", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Kamelet2-suffix"), new Matcher[0]);
    }

    @Test
    public void testDiscovered() {
        Response resp = (Response)RestAssured.given().contentType(ContentType.JSON).when().get("/kamelet/list", new Object[0]);
        ((ValidatableResponse)resp.then()).statusCode(200);
        ArrayList jsonAsArrayList = (ArrayList)resp.body().jsonPath().get("");
        Assertions.assertTrue((boolean)jsonAsArrayList.contains("injector"));
        Assertions.assertTrue((boolean)jsonAsArrayList.contains("logger"));
    }

    @Test
    public void testKameletLocationAtRuntime() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().post("/kamelet/locationAtRuntime/Hello", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"HELLO"), new Matcher[0]);
    }
}

