/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.ssl;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.strimzi.test.container.StrimziKafkaContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestResource;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestSupport;
import org.apache.camel.util.CollectionHelper;
import org.apache.commons.io.FileUtils;
import org.testcontainers.images.builder.Transferable;

public class KafkaSslTestResource
extends KafkaTestResource {
    private static final String KAFKA_KEYSTORE_FILE = "kafka-keystore.p12";
    private static final String KAFKA_KEYSTORE_PASSWORD = "kafkas3cret";
    private static final String KAFKA_KEYSTORE_TYPE = "PKCS12";
    private static final String KAFKA_TRUSTSTORE_FILE = "kafka-truststore.p12";
    private static final String KAFKA_CERTIFICATE_SCRIPT = "generate-certificates.sh";
    private static Path configDir;
    private SSLKafkaContainer container;

    public Map<String, String> start() {
        try {
            configDir = Files.createTempDirectory("KafkaSaslSslTestResource-", new FileAttribute[0]);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Stream.of(KAFKA_KEYSTORE_FILE, KAFKA_TRUSTSTORE_FILE).forEach(fileName -> {
                try (InputStream in = classLoader.getResourceAsStream("config/" + fileName);){
                    Files.copy(in, configDir.resolve((String)fileName), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KafkaTestSupport.regenerateCertificatesForDockerHost((Path)configDir, (String)KAFKA_CERTIFICATE_SCRIPT, (String)KAFKA_KEYSTORE_FILE, (String)KAFKA_TRUSTSTORE_FILE);
        this.container = new SSLKafkaContainer(KAFKA_IMAGE_NAME);
        this.container.waitForRunning();
        this.container.start();
        return CollectionHelper.mapOf((Object)"kafka.bootstrap.servers", (Object)this.container.getBootstrapServers(), (Object[])new Object[]{"camel.component.kafka.brokers", this.container.getBootstrapServers(), "camel.component.kafka.security-protocol", "SSL", "camel.component.kafka.ssl-key-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-location", configDir.resolve(KAFKA_KEYSTORE_FILE).toString(), "camel.component.kafka.ssl-keystore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-type", KAFKA_KEYSTORE_TYPE, "camel.component.kafka.ssl-truststore-location", configDir.resolve(KAFKA_TRUSTSTORE_FILE).toString(), "camel.component.kafka.ssl-truststore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-truststore-type", KAFKA_KEYSTORE_TYPE});
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
                FileUtils.deleteDirectory((File)configDir.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final class SSLKafkaContainer
    extends StrimziKafkaContainer {
        SSLKafkaContainer(String dockerImageName) {
            super(dockerImageName);
        }

        public String getBootstrapServers() {
            return String.format("SSL://%s:%s", this.getHost(), this.getMappedPort(9092));
        }

        protected void configure() {
            super.configure();
            String protocolMap = "SSL:SSL,BROKER1:PLAINTEXT";
            Map config = Map.ofEntries(Map.entry("inter.broker.listener.name", "BROKER1"), Map.entry("listener.security.protocol.map", protocolMap), Map.entry("ssl.keystore.location", "/etc/kafka/secrets/kafka-keystore.p12"), Map.entry("ssl.keystore.password", KafkaSslTestResource.KAFKA_KEYSTORE_PASSWORD), Map.entry("ssl.keystore.type", KafkaSslTestResource.KAFKA_KEYSTORE_TYPE), Map.entry("ssl.truststore.location", "/etc/kafka/secrets/kafka-truststore.p12"), Map.entry("ssl.truststore.password", KafkaSslTestResource.KAFKA_KEYSTORE_PASSWORD), Map.entry("ssl.truststore.type", KafkaSslTestResource.KAFKA_KEYSTORE_TYPE), Map.entry("ssl.endpoint.identification.algorithm", ""));
            this.withBrokerId(1);
            this.withKafkaConfigurationMap(config);
            this.withLogConsumer(frame -> System.out.print(frame.getUtf8String()));
        }

        protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
            super.containerIsStarting(containerInfo, reused);
            Stream.of(KafkaSslTestResource.KAFKA_KEYSTORE_FILE, KafkaSslTestResource.KAFKA_TRUSTSTORE_FILE).forEach(keyStoreFile -> {
                try {
                    this.copyFileToContainer(Transferable.of((byte[])Files.readAllBytes(configDir.resolve((String)keyStoreFile))), "/etc/kafka/secrets/" + keyStoreFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

