/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.ssl;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import me.escoffier.certs.Format;
import me.escoffier.certs.junit5.Certificate;
import org.apache.camel.quarkus.kafka.ssl.KafkaSslTestResource;
import org.apache.camel.quarkus.test.support.certificate.TestCertificates;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@TestCertificates(certificates={@Certificate(name="localhost", formats={Format.PKCS12}, password="PAG4i8511xp1lzVu585foRLjD4v62yBS")}, baseDir="target/certs", docker=true)
@QuarkusTest
@QuarkusTestResource(value=KafkaSslTestResource.class)
public class KafkaSslTest {
    @Test
    void testKafkaBridge() {
        String body = UUID.randomUUID().toString();
        ((ValidatableResponse)((Response)RestAssured.given().contentType("text/plain").body(body).post("/kafka-ssl/inbound", new Object[0])).then()).statusCode(200);
        JsonPath result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/kafka-ssl/outbound", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        Assertions.assertThat((String)result.getString("topicName")).isEqualTo("outbound");
        Assertions.assertThat((String)result.getString("body")).isEqualTo(body);
    }

    @Test
    void testQuarkusKafkaClientFactoryNotConfigured() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/kafka-ssl/custom/client/factory/missing", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }
}

