/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.ssl;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.strimzi.test.container.StrimziKafkaContainer;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestResource;
import org.apache.camel.util.CollectionHelper;
import org.testcontainers.utility.MountableFile;

public class KafkaSslTestResource
extends KafkaTestResource {
    static final String KAFKA_KEYSTORE_PASSWORD = "PAG4i8511xp1lzVu585foRLjD4v62yBS";
    static final String KAFKA_HOSTNAME = "localhost";
    static final String CERTS_BASEDIR = "target/certs";
    static final String KAFKA_KEYSTORE_FILE = "localhost-keystore.p12";
    static final String KAFKA_KEYSTORE_TYPE = "PKCS12";
    static final String KAFKA_TRUSTSTORE_FILE = "localhost-truststore.p12";

    public Map<String, String> start() {
        String bootstrapServers = this.start(name -> new SSLKafkaContainer((String)name));
        return CollectionHelper.mapOf((Object)"kafka.bootstrap.servers", (Object)bootstrapServers, (Object[])new Object[]{"camel.component.kafka.brokers", bootstrapServers, "camel.component.kafka.security-protocol", "SSL", "camel.component.kafka.ssl-key-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-location", Path.of(CERTS_BASEDIR, new String[0]).resolve(KAFKA_KEYSTORE_FILE).toString(), "camel.component.kafka.ssl-keystore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-type", KAFKA_KEYSTORE_TYPE, "camel.component.kafka.ssl-truststore-location", Path.of(CERTS_BASEDIR, new String[0]).resolve(KAFKA_TRUSTSTORE_FILE).toString(), "camel.component.kafka.ssl-truststore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-truststore-type", KAFKA_KEYSTORE_TYPE});
    }

    static final class SSLKafkaContainer
    extends StrimziKafkaContainer {
        SSLKafkaContainer(String dockerImageName) {
            super(dockerImageName);
        }

        public String getBootstrapServers() {
            return String.format("SSL://%s:%s", this.getHost(), this.getMappedPort(9092));
        }

        protected void configure() {
            super.configure();
            String protocolMap = "SSL:SSL,BROKER1:PLAINTEXT";
            Map config = Map.ofEntries(Map.entry("inter.broker.listener.name", "BROKER1"), Map.entry("listener.security.protocol.map", protocolMap), Map.entry("ssl.keystore.location", "/etc/kafka/secrets/localhost-keystore.p12"), Map.entry("ssl.keystore.password", KafkaSslTestResource.KAFKA_KEYSTORE_PASSWORD), Map.entry("ssl.keystore.type", KafkaSslTestResource.KAFKA_KEYSTORE_TYPE), Map.entry("ssl.truststore.location", "/etc/kafka/secrets/localhost-truststore.p12"), Map.entry("ssl.truststore.password", KafkaSslTestResource.KAFKA_KEYSTORE_PASSWORD), Map.entry("ssl.truststore.type", KafkaSslTestResource.KAFKA_KEYSTORE_TYPE), Map.entry("ssl.endpoint.identification.algorithm", ""));
            this.withEnv("STRIMZI_TEST_ROOT_LOG_LEVEL", "DEBUG");
            this.withBrokerId(1);
            this.withKafkaConfigurationMap(config);
            this.withLogConsumer(frame -> System.out.print(frame.getUtf8String()));
        }

        protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
            super.containerIsStarting(containerInfo, reused);
            Stream.of(KafkaSslTestResource.KAFKA_KEYSTORE_FILE, KafkaSslTestResource.KAFKA_TRUSTSTORE_FILE).forEach(keyStoreFile -> this.copyFileToContainer(MountableFile.forHostPath((Path)Path.of(KafkaSslTestResource.CERTS_BASEDIR, new String[0]).resolve((String)keyStoreFile)), "/etc/kafka/secrets/" + keyStoreFile));
        }
    }
}

