/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.ssl;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestResource;
import org.apache.camel.util.CollectionHelper;
import org.apache.commons.io.FileUtils;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class KafkaSslTestResource
extends KafkaTestResource {
    private static final String KAFKA_KEYSTORE_FILE = "kafka-keystore.p12";
    private static final String KAFKA_KEYSTORE_PASSWORD = "kafkas3cret";
    private static final String KAFKA_KEYSTORE_TYPE = "PKCS12";
    private static final String KAFKA_SSL_CREDS_FILE = "broker-creds";
    private static final String KAFKA_TRUSTSTORE_FILE = "kafka-truststore.p12";
    private Path configDir;
    private SSLKafkaContainer container;

    public Map<String, String> start() {
        try {
            this.configDir = Files.createTempDirectory("KafkaSaslSslTestResource-", new FileAttribute[0]);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Stream.of(KAFKA_KEYSTORE_FILE, KAFKA_TRUSTSTORE_FILE).forEach(fileName -> {
                try (InputStream in = classLoader.getResourceAsStream("config/" + fileName);){
                    Files.copy(in, this.configDir.resolve((String)fileName), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.container = new SSLKafkaContainer(KAFKA_IMAGE_NAME);
        this.container.start();
        return CollectionHelper.mapOf((Object)"kafka.bootstrap.servers", (Object)this.container.getBootstrapServers(), (Object[])new Object[]{"camel.component.kafka.brokers", this.container.getBootstrapServers(), "camel.component.kafka.security-protocol", "SSL", "camel.component.kafka.ssl-key-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-location", this.configDir.resolve(KAFKA_KEYSTORE_FILE).toString(), "camel.component.kafka.ssl-keystore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-type", KAFKA_KEYSTORE_TYPE, "camel.component.kafka.ssl-truststore-location", this.configDir.resolve(KAFKA_TRUSTSTORE_FILE).toString(), "camel.component.kafka.ssl-truststore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-truststore-type", KAFKA_KEYSTORE_TYPE});
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
                FileUtils.deleteDirectory((File)this.configDir.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final class SSLKafkaContainer
    extends KafkaContainer {
        SSLKafkaContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
            String protocolMap = "SSL:SSL,BROKER:PLAINTEXT";
            String listeners = "SSL://0.0.0.0:9093,BROKER://0.0.0.0:9092";
            this.withEnv("KAFKA_LISTENERS", listeners);
            this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", protocolMap);
            this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
            this.withEnv("KAFKA_SSL_KEY_CREDENTIALS", KafkaSslTestResource.KAFKA_SSL_CREDS_FILE);
            this.withEnv("KAFKA_SSL_KEYSTORE_FILENAME", KafkaSslTestResource.KAFKA_KEYSTORE_FILE);
            this.withEnv("KAFKA_SSL_KEYSTORE_CREDENTIALS", KafkaSslTestResource.KAFKA_SSL_CREDS_FILE);
            this.withEnv("KAFKA_SSL_KEYSTORE_TYPE", KafkaSslTestResource.KAFKA_KEYSTORE_TYPE);
            this.withEnv("KAFKA_SSL_TRUSTSTORE_FILENAME", KafkaSslTestResource.KAFKA_TRUSTSTORE_FILE);
            this.withEnv("KAFKA_SSL_TRUSTSTORE_CREDENTIALS", KafkaSslTestResource.KAFKA_SSL_CREDS_FILE);
            this.withEnv("KAFKA_SSL_TRUSTSTORE_TYPE", KafkaSslTestResource.KAFKA_KEYSTORE_TYPE);
            this.withEnv("KAFKA_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM", "");
            this.withEnv("KAFKA_CONFLUENT_SUPPORT_METRICS_ENABLE", "false");
            this.withEmbeddedZookeeper().waitingFor((WaitStrategy)Wait.forListeningPort());
            this.withLogConsumer(frame -> System.out.print(frame.getUtf8String()));
        }

        public String getBootstrapServers() {
            return String.format("SSL://%s:%s", this.getHost(), this.getMappedPort(9093));
        }

        protected void configure() {
            super.configure();
            String host = this.getNetwork() != null ? (String)this.getNetworkAliases().get(0) : "localhost";
            this.withEnv("KAFKA_ADVERTISED_LISTENERS", String.format("SSL://%s:9093,BROKER://%s:9092", host, host));
        }

        protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
            super.containerIsStarting(containerInfo, reused);
            this.copyFileToContainer(MountableFile.forClasspathResource((String)"config/kafka-keystore.p12"), "/etc/kafka/secrets/kafka-keystore.p12");
            this.copyFileToContainer(MountableFile.forClasspathResource((String)"config/kafka-truststore.p12"), "/etc/kafka/secrets/kafka-truststore.p12");
            this.copyFileToContainer(Transferable.of((byte[])KafkaSslTestResource.KAFKA_KEYSTORE_PASSWORD.getBytes(StandardCharsets.UTF_8)), "/etc/kafka/secrets/broker-creds");
        }
    }
}

