/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.ssl;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestSupport;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

@Path(value="/kafka-ssl")
@ApplicationScoped
public class KafkaSslResource {
    @Inject
    @Named(value="kafka-consumer-properties")
    Properties consumerProperties;
    @Inject
    @Named(value="kafka-producer-properties")
    Properties producerProperties;

    @Path(value="/{topicName}")
    @POST
    @Produces(value={"application/json"})
    public JsonObject post(@PathParam(value="topicName") String topicName, String message) throws Exception {
        Properties props = (Properties)this.producerProperties.clone();
        this.configureSSL(props);
        try (KafkaProducer producer = new KafkaProducer(props);){
            RecordMetadata meta = (RecordMetadata)producer.send(new ProducerRecord(topicName, (Object)1, (Object)message)).get();
            JsonObject jsonObject = Json.createObjectBuilder().add("topicName", meta.topic()).add("partition", meta.partition()).add("offset", meta.offset()).build();
            return jsonObject;
        }
    }

    @Path(value="/{topicName}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject get(@PathParam(value="topicName") String topicName) {
        Properties props = (Properties)this.consumerProperties.clone();
        this.configureSSL(props);
        try (KafkaConsumer consumer = new KafkaConsumer(props);){
            consumer.subscribe(Collections.singletonList(topicName));
            ConsumerRecord record = (ConsumerRecord)consumer.poll(Duration.ofSeconds(60L)).iterator().next();
            JsonObject jsonObject = Json.createObjectBuilder().add("topicName", record.topic()).add("partition", record.partition()).add("offset", record.offset()).add("key", ((Integer)record.key()).intValue()).add("body", (String)record.value()).build();
            return jsonObject;
        }
    }

    private void configureSSL(Properties props) {
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"security.protocol", (String)"camel.component.kafka.security-protocol");
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"ssl.key.password", (String)"camel.component.kafka.ssl-key-password");
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"ssl.keystore.location", (String)"camel.component.kafka.ssl-keystore-location");
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"ssl.keystore.password", (String)"camel.component.kafka.ssl-keystore-password");
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"ssl.keystore.type", (String)"camel.component.kafka.ssl-keystore-type");
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"ssl.truststore.location", (String)"camel.component.kafka.ssl-truststore-location");
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"ssl.truststore.password", (String)"camel.component.kafka.ssl-truststore-password");
        KafkaTestSupport.setKafkaConfigFromProperty((Properties)props, (String)"ssl.truststore.type", (String)"camel.component.kafka.ssl-truststore-type");
    }
}

