/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.sasl;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestSupport;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

@Path(value="/kafka-sasl")
@ApplicationScoped
public class KafkaSaslResource {
    @Inject
    @Named(value="kafka-consumer-properties")
    Properties consumerProperties;
    @Inject
    @Named(value="kafka-producer-properties")
    Properties producerProperties;

    @Path(value="/{topicName}")
    @POST
    @Produces(value={"application/json"})
    public JsonObject post(@PathParam(value="topicName") String topicName, String message) throws Exception {
        Properties props = (Properties)this.producerProperties.clone();
        KafkaTestSupport.setKafkaConfigProperty((Properties)props, (String)"security.protocol");
        KafkaTestSupport.setKafkaConfigProperty((Properties)props, (String)"sasl.mechanism");
        KafkaTestSupport.setKafkaConfigProperty((Properties)props, (String)"sasl.jaas.config");
        try (KafkaProducer producer = new KafkaProducer(props);){
            RecordMetadata meta = (RecordMetadata)producer.send(new ProducerRecord(topicName, (Object)1, (Object)message)).get();
            JsonObject jsonObject = Json.createObjectBuilder().add("topicName", meta.topic()).add("partition", meta.partition()).add("offset", meta.offset()).build();
            return jsonObject;
        }
    }

    @Path(value="/{topicName}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject get(@PathParam(value="topicName") String topicName) {
        Properties props = (Properties)this.consumerProperties.clone();
        KafkaTestSupport.setKafkaConfigProperty((Properties)props, (String)"security.protocol");
        KafkaTestSupport.setKafkaConfigProperty((Properties)props, (String)"sasl.mechanism");
        KafkaTestSupport.setKafkaConfigProperty((Properties)props, (String)"sasl.jaas.config");
        try (KafkaConsumer consumer = new KafkaConsumer(props);){
            consumer.subscribe(Collections.singletonList(topicName));
            ConsumerRecord record = (ConsumerRecord)consumer.poll(Duration.ofSeconds(60L)).iterator().next();
            JsonObject jsonObject = Json.createObjectBuilder().add("topicName", record.topic()).add("partition", record.partition()).add("offset", record.offset()).add("key", ((Integer)record.key()).intValue()).add("body", (String)record.value()).build();
            return jsonObject;
        }
    }
}

