/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.sasl;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestResource;
import org.apache.camel.util.CollectionHelper;
import org.apache.commons.io.FileUtils;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class KafkaSaslTestResource
extends KafkaTestResource {
    private Path serviceBindingDir;
    private SaslKafkaContainer container;

    public Map<String, String> start() {
        try {
            this.serviceBindingDir = Files.createTempDirectory("KafkaSaslTestResource-", new FileAttribute[0]);
            Path kafkaDir = this.serviceBindingDir.resolve("kafka");
            Files.createDirectories(kafkaDir, new FileAttribute[0]);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Stream.of("password", "saslMechanism", "securityProtocol", "type", "user").forEach(fileName -> {
                try (InputStream in = classLoader.getResourceAsStream("k8s-sb/kafka/" + fileName);){
                    Files.copy(in, kafkaDir.resolve((String)fileName), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.container = new SaslKafkaContainer(KAFKA_IMAGE_NAME);
        this.container.start();
        return CollectionHelper.mapOf((Object)"kafka.bootstrap.servers", (Object)this.container.getBootstrapServers(), (Object[])new Object[]{"quarkus.kubernetes-service-binding.root", this.serviceBindingDir.toString()});
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
                FileUtils.deleteDirectory((File)this.serviceBindingDir.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final class SaslKafkaContainer
    extends KafkaContainer {
        SaslKafkaContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
            String protocolMap = "SASL_PLAINTEXT:SASL_PLAINTEXT,BROKER:SASL_PLAINTEXT";
            String listeners = "SASL_PLAINTEXT://0.0.0.0:9093,BROKER://0.0.0.0:9092";
            this.withEnv("KAFKA_OPTS", "-Djava.security.auth.login.config=/etc/kafka/kafka_server_jaas.conf");
            this.withEnv("KAFKA_LISTENERS", listeners);
            this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", protocolMap);
            this.withEnv("KAFKA_CONFLUENT_SUPPORT_METRICS_ENABLE", "false");
            this.withEnv("KAFKA_SASL_ENABLED_MECHANISMS", "PLAIN");
            this.withEnv("ZOOKEEPER_SASL_ENABLED", "false");
            this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
            this.withEnv("KAFKA_SASL_MECHANISM_INTER_BROKER_PROTOCOL", "PLAIN");
            this.withEmbeddedZookeeper().waitingFor((WaitStrategy)Wait.forListeningPort());
        }

        public String getBootstrapServers() {
            return String.format("SASL_PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9093));
        }

        protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
            super.containerIsStarting(containerInfo, reused);
            this.copyFileToContainer(MountableFile.forClasspathResource((String)"config/kafka_server_jaas.conf"), "/etc/kafka/kafka_server_jaas.conf");
        }
    }
}

