/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.sasl;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestResource;
import org.apache.camel.util.CollectionHelper;
import org.apache.commons.io.FileUtils;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class KafkaSaslSslTestResource
extends KafkaTestResource {
    private static final String KAFKA_KEYSTORE_FILE = "kafka-keystore.p12";
    private static final String KAFKA_KEYSTORE_PASSWORD = "kafkas3cret";
    private static final String KAFKA_KEYSTORE_TYPE = "PKCS12";
    private static final String KAFKA_SSL_CREDS_FILE = "broker-creds";
    private static final String KAFKA_TRUSTSTORE_FILE = "kafka-truststore.p12";
    private Path configDir;
    private SaslSslKafkaContainer container;

    public Map<String, String> start() {
        try {
            this.configDir = Files.createTempDirectory("KafkaSaslSslTestResource-", new FileAttribute[0]);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Stream.of("kafka_server_jaas.conf", KAFKA_KEYSTORE_FILE, KAFKA_TRUSTSTORE_FILE).forEach(fileName -> {
                try (InputStream in = classLoader.getResourceAsStream("config/" + fileName);){
                    Files.copy(in, this.configDir.resolve((String)fileName), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.container = new SaslSslKafkaContainer(KAFKA_IMAGE_NAME);
        this.container.start();
        String jaasConfig = "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"alice\" password=\"alice-secret\";";
        return CollectionHelper.mapOf((Object)"camel.component.kafka.brokers", (Object)this.container.getBootstrapServers(), (Object[])new Object[]{"camel.component.kafka.sasl-mechanism", "SCRAM-SHA-512", "camel.component.kafka.sasl-jaas-config", jaasConfig, "camel.component.kafka.security-protocol", "SASL_SSL", "camel.component.kafka.ssl-key-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-location", this.configDir.resolve(KAFKA_KEYSTORE_FILE).toString(), "camel.component.kafka.ssl-keystore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-keystore-type", KAFKA_KEYSTORE_TYPE, "camel.component.kafka.ssl-truststore-location", this.configDir.resolve(KAFKA_TRUSTSTORE_FILE).toString(), "camel.component.kafka.ssl-truststore-password", KAFKA_KEYSTORE_PASSWORD, "camel.component.kafka.ssl-truststore-type", KAFKA_KEYSTORE_TYPE});
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
                FileUtils.deleteDirectory((File)this.configDir.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final class SaslSslKafkaContainer
    extends KafkaContainer {
        SaslSslKafkaContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
            String protocolMap = "SASL_SSL:SASL_SSL,BROKER:PLAINTEXT";
            String listeners = "SASL_SSL://0.0.0.0:9093,BROKER://0.0.0.0:9092";
            this.withEnv("KAFKA_OPTS", "-Djava.security.auth.login.config=/etc/kafka/kafka_server_jaas.conf");
            this.withEnv("KAFKA_LISTENERS", listeners);
            this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", protocolMap);
            this.withEnv("KAFKA_CONFLUENT_SUPPORT_METRICS_ENABLE", "false");
            this.withEnv("KAFKA_SASL_ENABLED_MECHANISMS", "SCRAM-SHA-512");
            this.withEnv("ZOOKEEPER_SASL_ENABLED", "false");
            this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
            this.withEnv("KAFKA_SASL_MECHANISM_INTER_BROKER_PROTOCOL", "SCRAM-SHA-512");
            this.withEnv("KAFKA_SSL_KEY_CREDENTIALS", KafkaSaslSslTestResource.KAFKA_SSL_CREDS_FILE);
            this.withEnv("KAFKA_SSL_KEYSTORE_FILENAME", KafkaSaslSslTestResource.KAFKA_KEYSTORE_FILE);
            this.withEnv("KAFKA_SSL_KEYSTORE_CREDENTIALS", KafkaSaslSslTestResource.KAFKA_SSL_CREDS_FILE);
            this.withEnv("KAFKA_SSL_KEYSTORE_TYPE", KafkaSaslSslTestResource.KAFKA_KEYSTORE_TYPE);
            this.withEnv("KAFKA_SSL_TRUSTSTORE_FILENAME", KafkaSaslSslTestResource.KAFKA_TRUSTSTORE_FILE);
            this.withEnv("KAFKA_SSL_TRUSTSTORE_CREDENTIALS", KafkaSaslSslTestResource.KAFKA_SSL_CREDS_FILE);
            this.withEnv("KAFKA_SSL_TRUSTSTORE_TYPE", KafkaSaslSslTestResource.KAFKA_KEYSTORE_TYPE);
            this.withEnv("KAFKA_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM", "");
            this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*started.*KafkaServer.*", (int)1));
        }

        public String getBootstrapServers() {
            return String.format("SASL_SSL://%s:%s", this.getHost(), this.getMappedPort(9093));
        }

        protected void configure() {
            super.configure();
            String host = this.getNetwork() != null ? (String)this.getNetworkAliases().get(0) : "localhost";
            this.withEnv("KAFKA_ADVERTISED_LISTENERS", String.format("SASL_SSL://%s:9093,BROKER://%s:9092", host, host));
        }

        protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
            super.containerIsStarting(containerInfo, reused);
            this.copyFileToContainer(MountableFile.forClasspathResource((String)"config/kafka_server_jaas.conf"), "/etc/kafka/kafka_server_jaas.conf");
            this.copyFileToContainer(MountableFile.forClasspathResource((String)"config/kafka-keystore.p12"), "/etc/kafka/secrets/kafka-keystore.p12");
            this.copyFileToContainer(MountableFile.forClasspathResource((String)"config/kafka-truststore.p12"), "/etc/kafka/secrets/kafka-truststore.p12");
            this.copyFileToContainer(Transferable.of((byte[])KafkaSaslSslTestResource.KAFKA_KEYSTORE_PASSWORD.getBytes(StandardCharsets.UTF_8)), "/etc/kafka/secrets/broker-creds");
            String setupUsersScript = "#!/bin/bash\nKAFKA_OPTS= /usr/bin/kafka-configs --zookeeper localhost:2181 --alter --add-config 'SCRAM-SHA-512=[iterations=8192,password=alice-secret]' --entity-type users --entity-name alice";
            this.copyFileToContainer(Transferable.of((byte[])setupUsersScript.getBytes(StandardCharsets.UTF_8), (int)509), "/setup-users.sh");
        }

        protected void containerIsStarted(InspectContainerResponse containerInfo) {
            super.containerIsStarted(containerInfo);
            try {
                this.execInContainer(new String[]{"/setup-users.sh"});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

