/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.oauth.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.keycloak.client.KeycloakTestClient;
import io.quarkus.test.keycloak.server.KeycloakContainer;
import io.strimzi.test.container.StrimziKafkaContainer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.utility.MountableFile;

public class KafkaKeycloakTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = Logger.getLogger(KafkaKeycloakTestResource.class);
    private static final String REALM_JSON = "keycloak/realms/kafka-authz-realm.json";
    private StrimziKafkaContainer kafka;
    private KeycloakContainer keycloak;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> start() {
        HashMap<String, String> properties;
        block9: {
            properties = new HashMap<String, String>();
            this.keycloak = new KeycloakContainer();
            this.keycloak.withStartupTimeout(Duration.ofMinutes(5L));
            this.keycloak.start();
            LOG.info((Object)this.keycloak.getLogs());
            Path realmJson = null;
            try {
                URL resource = Thread.currentThread().getContextClassLoader().getResource(REALM_JSON);
                if (resource == null) {
                    throw new RuntimeException("Unable to load keycloak/realms/kafka-authz-realm.json");
                }
                realmJson = Files.createTempFile("keycloak-auth", ".json", new FileAttribute[0]);
                IOUtils.copy((URL)resource, (File)realmJson.toFile());
                KeycloakTestClient client = new KeycloakTestClient(this.keycloak.getServerUrl());
                client.createRealmFromPath(realmJson.toAbsolutePath().toString());
                if (realmJson == null) break block9;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (realmJson == null) throw throwable;
                    try {
                        Files.deleteIfExists(realmJson);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                Files.deleteIfExists(realmJson);
            }
            catch (IOException resource) {}
        }
        String imageName = (String)ConfigProvider.getConfig().getValue("kafka-oauth.container.image", String.class);
        this.kafka = ((StrimziKafkaContainer)new StrimziKafkaContainer(imageName).withBrokerId(1).withKafkaConfigurationMap(Map.of("listener.security.protocol.map", "JWT:SASL_PLAINTEXT,BROKER1:PLAINTEXT", "listener.name.jwt.oauthbearer.sasl.jaas.config", this.getOauthSaslJaasConfig(this.keycloak.getInternalUrl(), this.keycloak.getServerUrl()), "listener.name.jwt.plain.sasl.jaas.config", this.getPlainSaslJaasConfig(this.keycloak.getInternalUrl(), this.keycloak.getServerUrl()))).withNetworkAliases(new String[]{"kafka"})).withServerProperties(MountableFile.forClasspathResource((String)"kafkaServer.properties")).withBootstrapServers(c -> String.format("JWT://%s:%s", c.getHost(), c.getMappedPort(9092)));
        this.kafka.start();
        LOG.info((Object)this.kafka.getLogs());
        properties.put("kafka.bootstrap.servers", this.kafka.getBootstrapServers());
        properties.put("camel.component.kafka.brokers", this.kafka.getBootstrapServers());
        properties.put("camel.component.kafka.security-protocol", "SASL_PLAINTEXT");
        properties.put("camel.component.kafka.sasl-mechanism", "OAUTHBEARER");
        properties.put("camel.component.kafka.additional-properties[sasl.login.callback.handler.class]", "io.strimzi.kafka.oauth.client.JaasClientOauthLoginCallbackHandler");
        properties.put("camel.component.kafka.sasl-jaas-config", this.getClientSaslJaasConfig(this.keycloak.getServerUrl()));
        return properties;
    }

    public void stop() {
        if (this.kafka != null) {
            this.kafka.stop();
        }
        if (this.keycloak != null) {
            this.keycloak.stop();
        }
    }

    private String getClientSaslJaasConfig(String keycloakServerUrl) {
        return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required oauth.client.id=\"kafka-client\" oauth.client.secret=\"kafka-client-secret\" oauth.token.endpoint.uri=\"" + keycloakServerUrl + "/realms/kafka-authz/protocol/openid-connect/token\";";
    }

    private String getPlainSaslJaasConfig(String keycloakInternalUrl, String keycloakServerUrl) {
        return "'org.apache.kafka.common.security.plain.PlainLoginModule required oauth.jwks.endpoint.uri=\"" + keycloakInternalUrl + "/realms/kafka-authz/protocol/openid-connect/certs\" oauth.valid.issuer.uri=\"" + keycloakServerUrl + "/realms/kafka-authz\" oauth.token.endpoint.uri=\"" + keycloakInternalUrl + "/realms/kafka-authz/protocol/openid-connect/token\" oauth.client.id=\"kafka\" oauth.client.secret=\"kafka-secret\" unsecuredLoginStringClaim_sub=\"admin\";'";
    }

    private String getOauthSaslJaasConfig(String keycloakInternalUrl, String keycloakServerUrl) {
        return "'org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required oauth.jwks.endpoint.uri=\"" + keycloakInternalUrl + "/realms/kafka-authz/protocol/openid-connect/certs\" oauth.valid.issuer.uri=\"" + keycloakServerUrl + "/realms/kafka-authz\" oauth.token.endpoint.uri=\"" + keycloakInternalUrl + "/realms/kafka-authz/protocol/openid-connect/token\" oauth.client.id=\"kafka\" oauth.client.secret=\"kafka-secret\";'";
    }
}

