/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.oauth.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.strimzi.test.container.StrimziKafkaContainer;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.quarkus.kafka.oauth.it.container.KeycloakContainer;
import org.jboss.logging.Logger;
import org.testcontainers.utility.MountableFile;

public class KafkaKeycloakTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger log = Logger.getLogger(KafkaKeycloakTestResource.class);
    private StrimziKafkaContainer kafka;
    private KeycloakContainer keycloak;

    public Map<String, String> start() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.keycloak = new KeycloakContainer();
        this.keycloak.start();
        log.info((Object)this.keycloak.getLogs());
        this.keycloak.createHostsFile();
        this.kafka = ((StrimziKafkaContainer)new StrimziKafkaContainer("quay.io/strimzi/kafka:latest-kafka-3.0.0").withBrokerId(1).withKafkaConfigurationMap(Map.of("listener.security.protocol.map", "JWT:SASL_PLAINTEXT,BROKER1:PLAINTEXT")).withNetworkAliases(new String[]{"kafka"})).withServerProperties(MountableFile.forClasspathResource((String)"kafkaServer.properties")).withBootstrapServers(c -> String.format("JWT://%s:%s", c.getContainerIpAddress(), c.getMappedPort(9092)));
        this.kafka.start();
        log.info((Object)this.kafka.getLogs());
        properties.put("kafka.bootstrap.servers", this.kafka.getBootstrapServers());
        properties.put("camel.component.kafka.brokers", this.kafka.getBootstrapServers());
        return properties;
    }

    public void stop() {
        if (this.kafka != null) {
            this.kafka.stop();
        }
        if (this.keycloak != null) {
            this.keycloak.stop();
        }
    }
}

