/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.oauth.it.container;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.FileWriter;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class KeycloakContainer
extends FixedHostPortGenericContainer<KeycloakContainer> {
    public KeycloakContainer() {
        super("quay.io/keycloak/keycloak:15.0.2");
        this.withExposedPorts(new Integer[]{8443});
        this.withFixedExposedPort(8080, 8080);
        this.withEnv("KEYCLOAK_USER", "admin");
        this.withEnv("KEYCLOAK_PASSWORD", "admin");
        this.withEnv("KEYCLOAK_HTTPS_PORT", "8443");
        this.withEnv("PROXY_ADDRESS_FORWARDING", "true");
        this.withEnv("KEYCLOAK_IMPORT", "/opt/jboss/keycloak/realms/kafka-authz-realm.json");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*WFLYSRV0025.*", (int)1));
        this.withNetwork(Network.SHARED);
        this.withNetworkAliases(new String[]{"keycloak"});
        this.withCreateContainerCmdModifier(cmd -> {
            cmd.withEntrypoint(new String[]{""});
            cmd.withCmd(new String[]{"/bin/bash", "-c", "cd /opt/jboss/keycloak && bin/jboss-cli.sh --file=ssl/keycloak-ssl.cli && rm -rf standalone/configuration/standalone_xml_history/current && cd .. && /opt/jboss/tools/docker-entrypoint.sh -Dkeycloak.profile.feature.upload_scripts=enabled -b 0.0.0.0"});
        });
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo);
        this.copyFileToContainer(MountableFile.forClasspathResource((String)"certificates/ca-truststore.p12"), "/opt/jboss/keycloak/standalone/configuration/certs/ca-truststore.p12");
        this.copyFileToContainer(MountableFile.forClasspathResource((String)"certificates/keycloak.server.keystore.p12"), "/opt/jboss/keycloak/standalone/configuration/certs/keycloak.server.keystore.p12");
        this.copyFileToContainer(MountableFile.forClasspathResource((String)"keycloak/scripts/keycloak-ssl.cli"), "/opt/jboss/keycloak/ssl/keycloak-ssl.cli");
        this.copyFileToContainer(MountableFile.forClasspathResource((String)"keycloak/realms/kafka-authz-realm.json"), "/opt/jboss/keycloak/realms/kafka-authz-realm.json");
    }

    public void createHostsFile() {
        try (FileWriter fileWriter = new FileWriter("target/hosts");){
            String dockerHost = this.getHost();
            if ("localhost".equals(dockerHost)) {
                fileWriter.write("127.0.0.1 keycloak");
            } else {
                fileWriter.write(dockerHost + " keycloak");
            }
            fileWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

