/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.kafka.oauth.it.container;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.strimzi.StrimziKafkaContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class KafkaContainer
extends FixedHostPortGenericContainer<KafkaContainer> {
    private static final Logger LOGGER = Logger.getLogger(KafkaContainer.class);
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    private static final int KAFKA_PORT = 9092;
    private static final String LATEST_KAFKA_VERSION;
    private static final List<String> supportedKafkaVersions;

    public KafkaContainer() {
        super("quay.io/strimzi/kafka:latest-kafka-" + LATEST_KAFKA_VERSION);
        this.withExposedPorts(new Integer[]{9092});
        this.withFixedExposedPort(9092, 9092);
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"kafkaServer.properties"), "/opt/kafka/config/server.properties");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Kafka startTimeMs:.*", (int)1));
        this.withNetwork(Network.SHARED);
        this.withNetworkAliases(new String[]{"kafka"});
        this.withEnv("LOG_DIR", "/tmp");
    }

    protected void doStart() {
        this.withCommand(new String[]{"sh", "-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
        super.doStart();
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        LOGGER.info((Object)("Kafka servers :: " + this.getBootstrapServers()));
        Object command = "#!/bin/bash \n";
        command = (String)command + "bin/zookeeper-server-start.sh ./config/zookeeper.properties &\n";
        command = (String)command + "export CLASSPATH=\"/opt/kafka/libs/strimzi/*:$CLASSPATH\" \n";
        command = (String)command + "bin/kafka-server-start.sh ./config/server.properties --override listeners=JWT://:9092 --override advertised.listeners=" + this.getBootstrapServers();
        this.copyFileToContainer(Transferable.of((byte[])((String)command).getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    public String getBootstrapServers() {
        return String.format("JWT://%s:%s", this.getHost(), 9092);
    }

    static {
        supportedKafkaVersions = new ArrayList<String>(3);
        InputStream inputStream = StrimziKafkaContainer.class.getResourceAsStream("/kafka-versions.txt");
        InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try (BufferedReader bufferedReader = new BufferedReader(streamReader);){
            String kafkaVersion;
            while ((kafkaVersion = bufferedReader.readLine()) != null) {
                supportedKafkaVersions.add(kafkaVersion);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unable to load the supported Kafka versions", (Throwable)e);
        }
        Collections.sort(supportedKafkaVersions);
        LATEST_KAFKA_VERSION = supportedKafkaVersions.get(supportedKafkaVersions.size() - 1);
    }
}

