/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jta.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.h2.H2DatabaseTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.apache.camel.quarkus.component.jta.it.ActiveMQXATestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=H2DatabaseTestResource.class), @QuarkusTestResource(value=ActiveMQXATestResource.class)})
class JtaTest {
    JtaTest() {
    }

    @Test
    public void testNoTx() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/required", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"required"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/requires_new", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"requires_new"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/mandatory", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"Policy 'PROPAGATION_MANDATORY' is configured but no active transaction was found!"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/never", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"never"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/supports", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"supports"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/not_supported", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"not_supported"), new Matcher[0]);
    }

    @Test
    public void testInTx() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/in_tx/required", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"required"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/in_tx/requires_new", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"requires_new"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/in_tx/mandatory", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"mandatory"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/in_tx/never", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"Policy 'PROPAGATION_NEVER' is configured but an active transaction was found!"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/in_tx/supports", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"supports"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/in_tx/not_supported", new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)"not_supported"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"jdbc", "sqltx"})
    public void testTx(String url) throws SQLException {
        String msg = UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/jta/" + url, new Object[0])).then()).statusCode(201)).body(Matchers.is((Object)(msg + " added")), new Matcher[0]);
        this.assertDBRowCount(url, 1);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("fail").post("/jta/" + url, new Object[0])).then()).statusCode(500);
        this.assertDBRowCount(url, 1);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/jta/mock", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"empty"), new Matcher[0])).log();
    }

    private void assertDBRowCount(String source, int expectedRowCount) throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:h2:tcp://localhost/mem:test");
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM example WHERE origin = '" + source + "'");){
            if (resultSet.next()) {
                Assertions.assertEquals((int)expectedRowCount, (int)resultSet.getInt(1));
            }
        }
    }
}

