/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jta.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ActiveMQXATestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQXATestResource.class);
    private static final String ACTIVEMQ_IMAGE = "vromero/activemq-artemis:2.11.0-alpine";
    private static final String ACTIVEMQ_USERNAME = "artemis";
    private static final String ACTIVEMQ_PASSWORD = "simetraehcapa";
    private static final int ACTIVEMQ_PORT = 61616;
    private GenericContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(ACTIVEMQ_IMAGE).withExposedPorts(new Integer[]{61616}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).withEnv("BROKER_CONFIG_MAX_DISK_USAGE", "100").waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            String brokerUrlTcp = String.format("tcp://%s:%d/", this.container.getContainerIpAddress(), this.container.getMappedPort(61616));
            return CollectionHelper.mapOf((Object)"quarkus.artemis.url", (Object)brokerUrlTcp, (Object[])new Object[]{"quarkus.artemis.username", ACTIVEMQ_USERNAME, "quarkus.artemis.password", ACTIVEMQ_PASSWORD});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

