/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jt400.mocked.it;

import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.MockAS400ImplRemote;
import com.ibm.as400.access.MockedResponses;
import com.ibm.as400.access.ReplyDQCommon;
import com.ibm.as400.access.ReplyDQReadNormal;
import com.ibm.as400.access.ReplyDQRequestAttributesNormal;
import com.ibm.as400.access.ReplyOk;
import com.ibm.as400.access.ReplyRCCallProgram;
import com.ibm.as400.access.ReplyRCExchangeAttributes;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.jt400.Jt400Component;
import org.jboss.logging.Logger;

@Path(value="/jt400/mock")
@ApplicationScoped
public class Jt400MockResource {
    private static final Logger LOG = Logger.getLogger(Jt400MockResource.class);
    private static final String COMPONENT_JT400 = "jt400";
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    MockAS400ImplRemote as400ImplRemote;

    @Path(value="/keyedDataQueue/read")
    @GET
    @Produces(value={"text/plain"})
    public Response keyedDataQueueRead() {
        Exchange ex = this.consumerTemplate.receive("jt400://username:password@system/qsys.lib/MSGOUTDQ.DTAQ?connectionPool=#mockPool&keyed=true&format=binary&searchKey=MYKEY&searchType=GE");
        return Response.ok().entity(ex.getIn().getBody(String.class)).build();
    }

    @Path(value="/keyedDataQueue/write/{key}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response keyedDataQueueWrite(@PathParam(value="key") String key, String data) throws Exception {
        Object ex = this.producerTemplate.requestBodyAndHeader("jt400://username:password@system/qsys.lib/MSGINDQ.DTAQ?connectionPool=#mockPool&keyed=true", (Object)data, "KEY", (Object)key);
        return Response.ok().entity(ex).build();
    }

    @Path(value="/messageQueue/read")
    @GET
    @Produces(value={"text/plain"})
    public Response messageQueueRead() throws InterruptedException {
        Exchange ex = this.consumerTemplate.receive("jt400://username:password@system/qsys.lib/MSGOUTQ.MSGQ?connectionPool=#mockPool&readTimeout=100");
        if (ex.getIn().getBody() != null) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @Path(value="/messageQueue/write/{key}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response messageQueueWrite(@PathParam(value="key") String key, String data) throws Exception {
        Object ex = this.producerTemplate.requestBodyAndHeader("jt400://username:password@system/qsys.lib/MSGINQ.MSGQ?connectionPool=#mockPool", (Object)data, "KEY", (Object)key);
        return Response.ok().entity(ex).build();
    }

    @Path(value="/programCall")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response programCall() throws Exception {
        Object ex = this.producerTemplate.requestBody("jt400://GRUPO:ATWORK@server/QSYS.LIB/assets.LIB/compute.PGM?connectionPool=#mockPool&outputFieldsIdx=1&fieldsLength=10,10,512", (Object)new String[]{"par1", "par2"});
        return Response.ok().entity(ex).build();
    }

    @Path(value="/put/mockResponse")
    @POST
    @Consumes(value={"application/json"})
    public Response putMockResponse(Map params) throws Exception {
        Object dataStream = switch (ReplyType.valueOf((String)params.get("replyType"))) {
            default -> throw new IncompatibleClassChangeError();
            case ReplyType.DQReadNormal -> new ReplyDQReadNormal((Integer)params.get("hashCode"), (String)params.get("senderInformation"), (String)params.get("entry"), (String)params.get("key"));
            case ReplyType.ok -> new ReplyOk();
            case ReplyType.DQCommonReply -> new ReplyDQCommon((Integer)params.get("hashCode"));
            case ReplyType.DQRequestAttributesNormal -> new ReplyDQRequestAttributesNormal((Integer)params.get("keyLength"));
            case ReplyType.RCExchangeAttributesReply -> new ReplyRCExchangeAttributes();
            case ReplyType.RCCallProgramReply -> new ReplyRCCallProgram();
        };
        MockedResponses.add((DataStream)dataStream);
        return Response.ok().build();
    }

    @Path(value="/component/stopWrong")
    @GET
    @Produces(value={"text/plain"})
    public Response stopComponent() throws Exception {
        Jt400Component comp = (Jt400Component)this.context.getComponent(COMPONENT_JT400, Jt400Component.class);
        comp.close();
        comp.getConnectionPool().close();
        return Response.ok().build();
    }

    public static enum ReplyType {
        DQReadNormal,
        ok,
        DQRequestAttributesNormal,
        DQCommonReply,
        RCExchangeAttributesReply,
        RCCallProgramReply;

    }
}

