/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jt400.mocked;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.quarkus.component.jt400.mocked.it.Jt400MockResource;
import org.apache.camel.util.CollectionHelper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class Jt400MockTest {
    @Test
    public void testReadKeyedDataQueue() {
        this.prepareMockReply(Jt400MockResource.ReplyType.ok);
        this.prepareMockReply(Jt400MockResource.ReplyType.DQRequestAttributesNormal, CollectionHelper.mapOf((Object)"keyLength", (Object)5, (Object[])new Object[0]));
        this.prepareMockReply(Jt400MockResource.ReplyType.ok);
        this.prepareMockReply(Jt400MockResource.ReplyType.DQReadNormal, 32771, "mocked jt400", "Hello from mocked jt400!", "MYKEY");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jt400/mock/keyedDataQueue/read", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"Hello from mocked jt400!"), new Matcher[0]);
    }

    @Test
    public void testWriteKeyedDataQueue() {
        this.prepareMockReply(Jt400MockResource.ReplyType.ok);
        this.prepareMockReply(Jt400MockResource.ReplyType.DQRequestAttributesNormal, CollectionHelper.mapOf((Object)"keyLength", (Object)7, (Object[])new Object[0]));
        this.prepareMockReply(Jt400MockResource.ReplyType.ok);
        this.prepareMockReply(Jt400MockResource.ReplyType.DQCommonReply, CollectionHelper.mapOf((Object)"hashCode", (Object)32770, (Object[])new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Written in mocked jt400!").post("/jt400/mock/keyedDataQueue/write/testKey", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"Written in mocked jt400!"), new Matcher[0]);
    }

    @Test
    public void testReadMessageQueue() {
        this.prepareMockReply(Jt400MockResource.ReplyType.RCExchangeAttributesReply);
        this.prepareMockReply(Jt400MockResource.ReplyType.RCExchangeAttributesReply);
        this.prepareMockReply(Jt400MockResource.ReplyType.RCCallProgramReply);
        ((ValidatableResponse)RestAssured.get((String)"/jt400/mock/messageQueue/read", (Object[])new Object[0]).then()).statusCode(200);
    }

    @Test
    public void testWriteMessageQueue() {
        this.prepareMockReply(Jt400MockResource.ReplyType.RCExchangeAttributesReply);
        this.prepareMockReply(Jt400MockResource.ReplyType.RCExchangeAttributesReply);
        this.prepareMockReply(Jt400MockResource.ReplyType.RCCallProgramReply);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Written in mocked jt400!").post("/jt400/mock/messageQueue/write/testKey", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"Written in mocked jt400!"), new Matcher[0]);
    }

    @Test
    public void testProgramCall() {
        this.prepareMockReply(Jt400MockResource.ReplyType.RCExchangeAttributesReply);
        this.prepareMockReply(Jt400MockResource.ReplyType.RCExchangeAttributesReply);
        this.prepareMockReply(Jt400MockResource.ReplyType.RCCallProgramReply);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Written in mocked jt400!").post("/jt400/mock/programCall", new Object[0])).then()).statusCode(200)).body((Matcher)Matchers.both((Matcher)Matchers.not((Matcher)Matchers.containsString((String)"par1"))).and(Matchers.containsString((String)"par2")), new Matcher[0]);
    }

    @Test
    public void testMissingResourceBundle() throws Exception {
        ((ValidatableResponse)RestAssured.get((String)"/jt400/mock/component/stopWrong", (Object[])new Object[0]).then()).statusCode(200);
    }

    private void prepareMockReply(Jt400MockResource.ReplyType replyType, Integer hashCode, String senderInformation, String entry, String key) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)CollectionHelper.mapOf((Object)"replyType", (Object)replyType.name(), (Object[])new Object[]{"hashCode", hashCode, "senderInformation", senderInformation, "entry", entry, "key", key})).post("/jt400/mock/put/mockResponse", new Object[0])).then()).statusCode(200);
    }

    private void prepareMockReply(Jt400MockResource.ReplyType replyType) {
        ((ValidatableResponse)((Response)RestAssured.given().body((Object)CollectionHelper.mapOf((Object)"replyType", (Object)replyType.name(), (Object[])new Object[0])).contentType(ContentType.JSON).post("/jt400/mock/put/mockResponse", new Object[0])).then()).statusCode(200);
    }

    private void prepareMockReply(Jt400MockResource.ReplyType replyType, Map<String, Object> data) {
        HashMap<String, Object> request = new HashMap<String, Object>(data);
        request.put("replyType", replyType.name());
        ((ValidatableResponse)((Response)RestAssured.given().body(request).contentType(ContentType.JSON).post("/jt400/mock/put/mockResponse", new Object[0])).then()).statusCode(200);
    }
}

