/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.path.it;

import com.jayway.jsonpath.Option;
import io.quarkus.runtime.annotations.RegisterForReflection;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.jsonpath.JsonPath;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.language.JsonPathExpression;

public class JsonPathTestRoute
extends RouteBuilder {
    public void configure() {
        JsonPathExpression jp = ((JsonPathExpression.Builder)((JsonPathExpression.Builder)((JsonPathExpression.Builder)this.expression().jsonpath().expression("$.book.price")).resultType(Integer.TYPE)).source("header:jsonBookHeader")).end();
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:getBookPriceLevel").choice().when().jsonpath("$.store.book[?(@.price < 10)]")).setBody((Expression)this.constant("cheap"))).when().jsonpath("$.store.book[?(@.price < 30)]")).setBody((Expression)this.constant("average"))).otherwise().setBody((Expression)this.constant("expensive"));
        this.from("direct:getBookPrice").setBody().jsonpath("$.store.book.price");
        this.from("direct:getFullName").bean(FullNameBean.class);
        this.from("direct:getAllCarColors").transform().jsonpath("$.cars[*].color");
        ((SplitDefinition)this.from("direct:splitBooks").split().jsonpath("$.books[*]")).to("mock:prices");
        ((RouteDefinition)this.from("direct:setHeader").setHeader("price", (Expression)jp)).to("mock:setHeader");
        this.from("direct:getAuthorsFromJsonStream").transform().jsonpath("$.store.book[*].title");
        ((SplitDefinition)this.from("direct:splitInputJsonThenWriteAsString").split().jsonpathWriteAsString("$.testjson.users")).to("mock:jsonpathWriteAsString");
    }

    @RegisterForReflection
    protected static class FullNameBean {
        protected FullNameBean() {
        }

        public static String getName(@JsonPath(value="person.firstName") String first, @JsonPath(value="person.middleName", options={Option.SUPPRESS_EXCEPTIONS}) String middle, @JsonPath(value="person.lastName") String last) {
            if (middle != null) {
                return first + " " + middle + " " + last;
            }
            return first + " " + last;
        }
    }
}

