/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.path.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JsonPathCharsetsTest {
    JsonPathCharsetsTest() {
    }

    @Test
    public void transformBooksUTF16BEShouldReturnTwoAuthors() throws IOException {
        byte[] body = IOUtils.resourceToByteArray((String)"/booksUTF16BE.json");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(body).get("/jsonpath/getAuthorsFromJsonStream", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Sayings of the Century-Sword of Honour"), new Matcher[0]);
    }

    @Test
    public void transformBooksUTF16LEShouldReturnTwoAuthors() throws IOException {
        byte[] body = IOUtils.resourceToByteArray((String)"/booksUTF16LE.json");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(body).get("/jsonpath/getAuthorsFromJsonStream", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Sayings of the Century-Sword of Honour"), new Matcher[0]);
    }

    @Test
    public void transformBooksIso_8859_1_ShouldReturnTwoAuthors() throws IOException {
        byte[] body = IOUtils.resourceToByteArray((String)"/germanbooks-iso-8859-1.json");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("encoding", new Object[]{"ISO-8859-1"}).body(body).get("/jsonpath/getAuthorsFromJsonStream", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Joseph und seine Br\u00fcder-G\u00f6tzend\u00e4mmerung"), new Matcher[0]);
    }
}

