/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.path.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.json.path.it.PersonRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JsonPathBeanTest {
    private PersonRequest personRequest;

    JsonPathBeanTest() {
    }

    @BeforeEach
    public void setup() {
        this.personRequest = new PersonRequest();
        this.personRequest.setPerson(new PersonRequest.Person());
        this.personRequest.getPerson().setFirstName("Christophe");
        this.personRequest.getPerson().setMiddleName("Sylvain");
        this.personRequest.getPerson().setLastName("Fontane");
    }

    @Test
    public void getFullNameShouldSucceed() {
        String fullName = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.personRequest).get("/jsonpath/getFullName", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)"Christophe Sylvain Fontane", (Object)fullName);
    }

    @Test
    public void getFullNameWihtoutMiddleNameShouldSucceed() {
        this.personRequest.getPerson().setMiddleName(null);
        String fullName = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.personRequest).get("/jsonpath/getFullName", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)"Christophe Fontane", (Object)fullName);
    }
}

