/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.path.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.json.path.it.StoreRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JsonPathContentBasedRouterTest {
    private StoreRequest storeRequest;

    JsonPathContentBasedRouterTest() {
    }

    @BeforeEach
    public void setup() {
        this.storeRequest = new StoreRequest();
        this.storeRequest.setStore(new StoreRequest.Store());
        this.storeRequest.getStore().setBook(new StoreRequest.Book());
        this.storeRequest.getStore().getBook().setPrice(5.0);
    }

    @Test
    public void priceLessThan10ShouldReturnCheapLevel() {
        String priceLevel = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.storeRequest).get("/jsonpath/getBookPriceLevel", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)"cheap", (Object)priceLevel);
    }

    @Test
    public void priceBetween10And30ShouldReturnAverageLevel() {
        this.storeRequest.getStore().getBook().setPrice(17.5);
        String priceLevel = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.storeRequest).get("/jsonpath/getBookPriceLevel", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)"average", (Object)priceLevel);
    }

    @Test
    public void priceGreaterThan30ShouldReturnExpensiveLevel() {
        this.storeRequest.getStore().getBook().setPrice(31.7);
        String priceLevel = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this.storeRequest).get("/jsonpath/getBookPriceLevel", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)"expensive", (Object)priceLevel);
    }
}

