/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.path.it;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;

@Path(value="/jsonpath")
@ApplicationScoped
public class JsonPathResource {
    private static final Logger LOG = Logger.getLogger(JsonPathResource.class);
    private static final String WRITE_AS_STRING_TEST_DATA = "{\"testjson\":{\"users\":[{\"name\":\"Jan\",\"age\":28},{\"age\":10},{\"name\":\"Tom\",\"age\":50}],\"boolean\":true,\"color\":\"gold\",\"null\":null,\"number\":123,\"object\":{\"objectX\":\"myObjectX\",\"objectY\":\"secondbestobject\",\"subObject\":{\"obj1\":\"obj1desc\"}},\"string\":\"HelloWorld\"}}";
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/getBookPriceLevel")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getBookPriceLevel(String storeRequestJson) {
        LOG.debugf("Getting book price level from json store request: %s", (Object)storeRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getBookPriceLevel", (Object)storeRequestJson, String.class);
    }

    @Path(value="/getBookPrice")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getBookPrice(String storeRequestJson) {
        LOG.debugf("Getting book price from json store request: %s", (Object)storeRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getBookPrice", (Object)storeRequestJson, String.class);
    }

    @Path(value="/getFullName")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getFullName(String personRequestJson) {
        LOG.debugf("Getting person full name from json person request: %s", (Object)personRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getFullName", (Object)personRequestJson, String.class);
    }

    @Path(value="/getAllCarColors")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getAllCarColors(String carsRequestJson) {
        LOG.debugf("Getting all car colors from json cars request: %s", (Object)carsRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getAllCarColors", (Object)carsRequestJson, String.class);
    }

    @Path(value="/splitBooksShouldReturnTwoPrices")
    @GET
    public void splitBooksShouldReturnThreePrices() throws InterruptedException {
        LOG.debugf("Calling splitBooksShouldReturnThreePrices()", new Object[0]);
        String body = "{\"books\": [{\"price\": 30},{ \"price\": 20}]}";
        MockEndpoint mockPrices = (MockEndpoint)this.context.getEndpoint("mock:prices", MockEndpoint.class);
        mockPrices.expectedMessageCount(2);
        this.producerTemplate.requestBody("direct:splitBooks", (Object)body, String.class);
        mockPrices.assertIsSatisfied();
        List exchanges = mockPrices.getReceivedExchanges();
        Assertions.assertNotNull((Object)exchanges);
        Assertions.assertEquals((int)2, (int)exchanges.size());
        Map firstRow = (Map)((Exchange)exchanges.get(0)).getIn().getBody(Map.class);
        Assertions.assertNotNull((Object)firstRow);
        Assertions.assertEquals((Object)30, firstRow.get("price"));
        Map secondRow = (Map)((Exchange)exchanges.get(1)).getIn().getBody(Map.class);
        Assertions.assertNotNull((Object)secondRow);
        Assertions.assertEquals((Object)20, secondRow.get("price"));
    }

    @Path(value="/setHeaderWithJsonPathExpressionEvaluatingAnotherHeaderShouldSucceed")
    @GET
    public void setHeaderWithJsonPathExpressionEvaluatingAnotherHeaderShouldSucceed() throws InterruptedException {
        LOG.debugf("Calling setHeaderWithJsonPathExpressionEvaluatingAnotherHeaderShouldSucceed()", new Object[0]);
        String json = "{\"book\": {\"price\": 25} }";
        MockEndpoint mockSetHeader = (MockEndpoint)this.context.getEndpoint("mock:setHeader", MockEndpoint.class);
        mockSetHeader.expectedMessageCount(1);
        mockSetHeader.expectedHeaderReceived("price", (Object)25);
        this.producerTemplate.requestBodyAndHeader("direct:setHeader", null, "jsonBookHeader", (Object)json, Message.class);
        mockSetHeader.assertIsSatisfied();
    }

    @Path(value="/getAuthorsFromJsonStream")
    @GET
    @Produces(value={"text/plain"})
    @Consumes(value={"application/octet-stream"})
    public String getAuthorsFromJsonStream(byte[] jsonBytes, @QueryParam(value="encoding") String encoding) throws IOException {
        List bookTitles;
        LOG.debugf("Getting authors from JsonStream with encoding '%s' and %d bytes", (Object)encoding, (Object)jsonBytes.length);
        try (ByteArrayInputStream jsonStream = new ByteArrayInputStream(jsonBytes);){
            bookTitles = encoding == null ? (List)this.producerTemplate.requestBody("direct:getAuthorsFromJsonStream", (Object)jsonStream, List.class) : (List)this.producerTemplate.requestBodyAndHeader("direct:getAuthorsFromJsonStream", (Object)jsonStream, "CamelJsonPathJsonEncoding", (Object)encoding, List.class);
        }
        return StringUtils.join((Iterable)bookTitles, (String)"-");
    }

    @Path(value="/splitInputJsonThenWriteAsStringShouldSucceed")
    @GET
    public void splitInputJsonThenWriteAsStringShouldSucceed() throws InterruptedException {
        LOG.debugf("Split input json and then use jsonpath writeAsString", new Object[0]);
        MockEndpoint mockJsonpathWriteAsString = (MockEndpoint)this.context.getEndpoint("mock:jsonpathWriteAsString", MockEndpoint.class);
        mockJsonpathWriteAsString.expectedMessageCount(3);
        ArrayList<String> expectedBodies = new ArrayList<String>();
        expectedBodies.add("{\"name\":\"Jan\",\"age\":28}");
        expectedBodies.add("{\"age\":10}");
        expectedBodies.add("{\"name\":\"Tom\",\"age\":50}");
        mockJsonpathWriteAsString.expectedBodiesReceived(expectedBodies);
        this.producerTemplate.requestBody("direct:splitInputJsonThenWriteAsString", (Object)WRITE_AS_STRING_TEST_DATA, String.class);
        mockJsonpathWriteAsString.assertIsSatisfied();
    }
}

