/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.path.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/jsonpath")
@ApplicationScoped
public class JsonPathResource {
    private static final Logger LOG = Logger.getLogger(JsonPathResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/getBookPriceLevel")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getBookPriceLevel(String storeRequestJson) {
        LOG.infof("Getting book price level from json store request: %s", (Object)storeRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getBookPriceLevel", (Object)storeRequestJson, String.class);
    }

    @Path(value="/getBookPrice")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getBookPrice(String storeRequestJson) {
        LOG.infof("Getting book price from json store request: %s", (Object)storeRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getBookPrice", (Object)storeRequestJson, String.class);
    }

    @Path(value="/getFullName")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getFullName(String personRequestJson) {
        LOG.infof("Getting person full name from json person request: %s", (Object)personRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getFullName", (Object)personRequestJson, String.class);
    }

    @Path(value="/getAllCarColors")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String getAllCarColors(String carsRequestJson) {
        LOG.infof("Getting all car colors from json cars request: %s", (Object)carsRequestJson);
        return (String)this.producerTemplate.requestBody("direct:getAllCarColors", (Object)carsRequestJson, String.class);
    }
}

