/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.validator.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/json-validator")
@ApplicationScoped
public class JsonValidatorResource {
    private static final Logger LOG = Logger.getLogger(JsonValidatorResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/validate")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String validate(String json) {
        LOG.infof("Calling validate with: %s", (Object)json);
        return (String)this.producerTemplate.requestBody("direct:validate-json", (Object)json, String.class);
    }

    @Path(value="/validate-as-stream")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String validateAsStream(String json) {
        LOG.infof("Calling validateAsStream with: %s", (Object)json);
        ByteArrayInputStream bais = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        return (String)this.producerTemplate.requestBody("direct:validate-json", (Object)bais, String.class) + "-as-stream";
    }

    @Path(value="/validate-from-header")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String validateFromHeader(String json) {
        LOG.infof("Calling validateFromHeader with: %s", (Object)json);
        return (String)this.producerTemplate.requestBodyAndHeader("direct:validate-json-from-header", null, "headerToValidate", (Object)json, String.class);
    }
}

