/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.validator.it;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/json-validator")
@ApplicationScoped
public class JsonValidatorResource {
    private static final Logger LOG = Logger.getLogger(JsonValidatorResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/validate")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String validate(String json) {
        LOG.infof("Calling validate with: %s", (Object)json);
        return (String)this.producerTemplate.requestBody("direct:validate-json", (Object)json, String.class);
    }

    @Path(value="/validate-as-stream")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String validateAsStream(String json) {
        LOG.infof("Calling validateAsStream with: %s", (Object)json);
        ByteArrayInputStream bais = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        return (String)this.producerTemplate.requestBody("direct:validate-json", (Object)bais, String.class) + "-as-stream";
    }

    @Path(value="/validate-from-header")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String validateFromHeader(String json) {
        LOG.infof("Calling validateFromHeader with: %s", (Object)json);
        return (String)this.producerTemplate.requestBodyAndHeader("direct:validate-json-from-header", null, "headerToValidate", (Object)json, String.class);
    }
}

