/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.validator.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JsonValidatorTest {
    JsonValidatorTest() {
    }

    @Test
    public void validJsonShouldBeValidated() {
        String validJson = "{ \"name\": \"John Doe\", \"id\": 1, \"price\": 12.5 }";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{ \"name\": \"John Doe\", \"id\": 1, \"price\": 12.5 }").get("/json-validator/validate", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"valid"), new Matcher[0]);
    }

    @Test
    public void invalidJsonShouldNotBeValidated() {
        String invalidJson = "{ \"name\": \"John Doe\", \"id\": \"AA1\", \"price\": 12.5 }";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{ \"name\": \"John Doe\", \"id\": \"AA1\", \"price\": 12.5 }").get("/json-validator/validate", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"invalid"), new Matcher[0]);
    }

    @Test
    public void validJsonFromHeaderShouldBeValidated() {
        String validJson = "{ \"name\": \"John Doe\", \"id\": 1, \"price\": 12.5 }";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{ \"name\": \"John Doe\", \"id\": 1, \"price\": 12.5 }").get("/json-validator/validate-from-header", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"valid-header"), new Matcher[0]);
    }

    @Test
    public void invalidJsonFromHeaderShouldNotBeValidated() {
        String invalidJson = "{ \"name\": \"John Doe\", \"id\": \"AA1\", \"price\": 12.5 }";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{ \"name\": \"John Doe\", \"id\": \"AA1\", \"price\": 12.5 }").get("/json-validator/validate-from-header", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"invalid-header"), new Matcher[0]);
    }

    @Test
    public void validJsonAsStreamShouldBeValidated() {
        String validJson = "{ \"name\": \"John Doe\", \"id\": 1, \"price\": 12.5 }";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{ \"name\": \"John Doe\", \"id\": 1, \"price\": 12.5 }").get("/json-validator/validate-as-stream", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"valid-as-stream"), new Matcher[0]);
    }

    @Test
    public void invalidJsonAsStreamShouldNotBeValidated() {
        String invalidJson = "{ \"name\": \"John Doe\", \"id\": \"AA1\", \"price\": 12.5 }";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{ \"name\": \"John Doe\", \"id\": \"AA1\", \"price\": 12.5 }").get("/json-validator/validate-as-stream", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"invalid-as-stream"), new Matcher[0]);
    }
}

