/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jslt.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.jslt.it.JsltConfiguration;
import org.jboss.logging.Logger;

@Path(value="/jslt")
@ApplicationScoped
public class JsltResource {
    private static final Logger LOG = Logger.getLogger(JsltResource.class);
    @Inject
    ProducerTemplate template;

    @Path(value="/transformInputStream")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String transformInputStream(String input) throws IOException {
        LOG.debugf("Invoking transformInputStream(%s)", (Object)input);
        try (ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            String string = (String)this.template.requestBody("jslt:demoPlayground/transformation.json", (Object)is, String.class);
            return string;
        }
    }

    @Path(value="/transformInvalidBody")
    @GET
    @Produces(value={"text/plain"})
    public String transformInvalidBody() {
        LOG.debugf("Invoking transformInvalidBody()", new Object[0]);
        try {
            this.template.requestBody("jslt:demoPlayground/transformation.json", (Object)4, String.class);
        }
        catch (CamelExecutionException vex) {
            return vex.getCause().getMessage();
        }
        return null;
    }

    @Path(value="/transformString")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String transformString(String input) {
        LOG.debugf("Invoking transformString(%s)", (Object)input);
        return (String)this.template.requestBody("jslt:demoPlayground/transformation.json", (Object)input, String.class);
    }

    @Path(value="/transformFromHeaderWithPrettyPrint")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String transformFromHeaderWithPrettyPrint(String input) throws IOException {
        LOG.debugf("Invoking transformFromHeaderWithPrettyPrint(%s)", (Object)input);
        Map<String, String> headers = Collections.singletonMap("CamelJsltResourceUri", "demoPlayground/transformation.json");
        try (ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            String uri = "jslt:demoPlayground/transformation.json?prettyPrint=true&allowTemplateFromHeader=true";
            String string = (String)this.template.requestBodyAndHeaders(uri, (Object)is, headers, String.class);
            return string;
        }
    }

    @Path(value="/transformInputStreamWithFilter")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String transformInputStreamWithFilter(String input) throws IOException {
        LOG.debugf("Invoking transformInputStreamWithFilter(%s)", (Object)input);
        try (ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            String uri = "jsltWithFilter:objectFilter/transformation.json";
            String string = (String)this.template.requestBody(uri, (Object)is, String.class);
            return string;
        }
    }

    @Path(value="/transformInputStreamWithVariables")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String transformInputStreamWithVariables(String input) throws IOException {
        LOG.debugf("Invoking transformInputStreamWithVariables(%s)", (Object)input);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("published", "2020-05-26T16:00:00+02:00");
        headers.put("type", "Controller");
        headers.put("infinite", JsltConfiguration.createInfiniteRecursionObject());
        try (ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            String uri = "jslt:withVariables/transformation.json";
            String string = (String)this.template.requestBodyAndHeaders(uri, (Object)is, headers, String.class);
            return string;
        }
    }

    @Path(value="/transformInputStreamWithVariablesAndProperties")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String transformInputStreamWithVariablesAndProperties(String input) throws IOException {
        LOG.debugf("Invoking transformInputStreamWithVariablesAndProperties(%s)", (Object)input);
        try (ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            String uri = "jslt:withVariables/transformationWithProperties.json?allowContextMapAll=true";
            Exchange ex = this.template.request(uri, e -> {
                e.getMessage().setBody((Object)is);
                e.getMessage().setHeader("published", (Object)"2020-05-26T16:00:00+02:00");
                e.getMessage().setHeader("type", (Object)"Controller");
                e.setProperty("infinite", (Object)JsltConfiguration.createInfiniteRecursionObject());
                e.setProperty("instance", (Object)"559e934f-b32b-47ab-8327-bd50e2bdc029");
            });
            String string = (String)ex.getMessage().getBody(String.class);
            return string;
        }
    }

    @Path(value="/transformWithFunction")
    @GET
    @Produces(value={"text/plain"})
    public String transformWithFunction() {
        LOG.debugf("Invoking transformWithFunction()", new Object[0]);
        Map<String, String> headers = Collections.singletonMap("CamelJsltString", "power(2, 10)");
        return (String)this.template.requestBodyAndHeaders("jsltWithFunction:dummy", (Object)"{}", headers, String.class);
    }
}

